import { createHiveChain } from "@hiveio/wax";
import createBeekeeper from "@hiveio/beekeeper";

const privateKey = "5JkGtAcuQN6YqJCfbsdTxviCEQY7FABUgA6JTNVttVtR6zbQbJJ";

(async () => {
  const bk = await createBeekeeper({ enableLogs: false });
  const session = bk.createSession("salt");
  const { wallet } = await session.createWallet("salt", "password", true);
  const publicKey = await wallet.importKey(privateKey);

  // STM7KN9xioFiCLcbjkhixcEiNhVqg46FhMDBGz2LF1DQNccnppBfm
  console.log(publicKey);

  const wax = await createHiveChain();
  const tx = wax.createTransactionWithTaPoS("00000000000000000000000000000000000000", 1);

  tx.pushOperation({
    vote: {
      author: "guest4test",
      voter: "guest4test",
      permlink: "test",
      weight: 10000
    }
  });

  tx.sign(wallet, publicKey);

  console.log(wax.getPublicKeyFromSignature(tx.sigDigest, "20ee0940550853ee503541056d1fd4fcb1b7b3bccaf2b8c15646a2e9d125ab25b72dfa1c24dbbbc96ab3fa33046b281374b26cd81c23f46981953d4bd1a8102c55"));

  // d217db3918d4c53ab5890b9e949244a7c6ad390b2717629279d2c60f6823377e
  // 1f626568b27c2bb265594a6fed91aa94edbc654778517127786cf1cdcb66b44abb43d08e2a404f967bae5267b7a6f83206a3b805a1a62eb0c30692877cbc96d579
  // 20ee0940550853ee503541056d1fd4fcb1b7b3bccaf2b8c15646a2e9d125ab25b72dfa1c24dbbbc96ab3fa33046b281374b26cd81c23f46981953d4bd1a8102c55
  console.log(tx.sigDigest, JSON.stringify(tx.toApiJson()), tx.transaction.signatures[0]);
})();
