import type { THexString, TPublicKey, TRole } from "@hiveio/wax";

export interface KeyIndex {
  accountIndex?: number;
  role: TRole;
}

export interface PublicKeyData extends Required<KeyIndex> {
  publicKey: TPublicKey;
}

export interface GetPublicKeyRequest {
  method: 'hive_getPublicKeys';
  params: {
    keys: KeyIndex[];
  };
};

export interface SignTransactionRequest {
  method: 'hive_signTransaction';
  params: {
    transaction: string;
    keys: KeyIndex[];
  };
}

export interface GetPublicKeyResponse {
  publicKeys: PublicKeyData[];
}

export interface SignTransactionResponse {
  signatures: THexString[];
}

export type RpcRequest = GetPublicKeyRequest | SignTransactionRequest;
export type RpcResponse = GetPublicKeyResponse | SignTransactionResponse;
