import createBeekeeper, { IBeekeeperInstance, IBeekeeperSession } from "@hiveio/beekeeper";

let _beekeeper: undefined | IBeekeeperInstance;
let _session: undefined | IBeekeeperSession;
const getBeekeeperSession = async () => {
  if (!_beekeeper) {
    _beekeeper = await createBeekeeper({ enableLogs: false, inMemory: true });
    _session = _beekeeper.createSession("salt");
  }

  return _session!;
};

export const getTempWallet = async () => {
  const session = await getBeekeeperSession();
  const walletName = "w" + Date.now();
  const { wallet } = await session.createWallet(walletName, "pass", true);
  return wallet;
};
