import { EXIT_CODES } from "../exit-codes.js";
import { logger } from "./logger.js";
import { existsSync } from 'node:fs';
import { join, normalize } from "node:path";

/**
 * Traverses the PATH environment variable to find the path to the executable
 */
export const which = (execName: string, pathEnv: string | undefined = process.env.PATH): (string | void) => {
  if (typeof pathEnv !== 'string') {
    logger.error('❌ The PATH environment variable is not a string. 🚫');

    process.exit(EXIT_CODES.PATH_ENV_NOT_SET);
  }

  const paths = pathEnv.split(':');

  for (const path of paths) {
    const execFullPath = normalize(join(path, execName));

    if (existsSync(execFullPath))
      return execFullPath;
  }
};
