import ourConfigSchema from "../../config-schema.json" with { type: "json" };
import Ajv from "ajv";
import { existsSync, readFileSync } from 'node:fs';
import { logger } from "./logger.js";
import { EXIT_CODES } from "../exit-codes.js";
import type { HiveCombPluginConfiguration } from "../../dist/config.js";
import { iterate } from "./iterate.js";

export const DEFAULT_COMB_CONFIG_FILENAME = 'comb.config.json';

export const DEFAULT_CONFIGURATION: HiveCombPluginConfiguration = {
  useGitlabPackageRegistry: true
};

export const validateConfig = (otherConfigPath: string): HiveCombPluginConfiguration => {
  try {
    const source = structuredClone(DEFAULT_CONFIGURATION);

    if (!existsSync(otherConfigPath))
      return source;

    const data = JSON.parse(readFileSync(otherConfigPath, 'utf8'));

    const ajv = new Ajv();
    const validate = ajv.compile(ourConfigSchema);

    const valid = validate(data);
    if (!valid) {
      logger.error(`❌ Error parsing config file: ${validate.errors!.length} validation errors found: "${validate.errors!.map(error => error.message!).join('", "')}" 🔧`);

      process.exit(EXIT_CODES.CONFIG_PARSE_ERROR);
    }

    return iterate(source, data);
  } catch (error) {
    logger.error(`❌ Error parsing config file: ${error instanceof Error ? error.message : error} 🔧`);

    process.exit(EXIT_CODES.CONFIG_PARSE_ERROR);
  }
};
