import { EXIT_CODES } from "../exit-codes.js";
import { logger } from "./logger.js";
import { execSync } from 'node:child_process';

/**
 * Traverses the PATH environment variable to find the path to the executable
 */
export const exec = (command: string): string => {
  try {
    logger.verbose(`⚙️ ${command}`);

    return execSync(command, {
      encoding: 'utf8',
      env: process.env,
      cwd: process.cwd(),
      uid: process.getuid?.(),
      gid: process.getgid?.(),
      shell: process.env.SHELL,
      windowsHide: true,
      stdio: ['ignore', 'pipe', 'pipe']
    });
  } catch (error) {
    logger.error(`❌ ${error instanceof Error ? error.message : error}`);

    process.exit(EXIT_CODES.CHILD_PROCESS_COMMAND_ERROR);
  }
};
