import { Script } from 'node:vm';
import { EXIT_CODES } from '../exit-codes.js';

export const newContextEval = <T = any>(code: string): T => {
  try {
    const script = new Script(code);

    return script.runInNewContext();
  } catch (error) {
    console.error(`❌ Error evaluating context: ${error instanceof Error ? error.message : error}`);

    process.exit(EXIT_CODES.NEW_CONTEXT_EVAL_ERROR);
  }
};
