import yargs from "yargs";
import { hideBin }from "yargs/helpers";
import { DEFAULT_COMB_CONFIG_FILENAME } from "./utils/parse-app-config.js";

export const parseOptions = () => yargs(hideBin(process.argv))
  .option("project-root", {
    alias: "P",
    type: "string",
    description: "Project root directory. Defaults to the CWD (current working directory) when not provided. "
      + "Used to locate your project files and main package.json entry. You can also set it via the COMB_PROJECT_ROOT environment variable.",
    default: "."
  })
  .option("config", {
    alias: "c",
    type: "string",
    description: "Config file to use. Defaults to comb.config.json in the project root directory.",
    default: DEFAULT_COMB_CONFIG_FILENAME
  })
  .option("verbose", {
    alias: "v",
    type: "boolean",
    description: "Enable verbose logging",
    default: false
  })
  .parse();
