#!/usr/bin/env node

import { isAbsolute, normalize, join } from "node:path";
import { parseOptions }from "./parse-args.js";
import { checkOS } from "./stages/check-os.js";
import { checkNodeVersion, checkPnpmVersion } from "./stages/check-node-version.js";
import { logger } from "./utils/logger.js";
import { validateConfig } from "./utils/parse-app-config.js";

const argv = await parseOptions();

if (argv.verbose)
  logger.level = 'verbose';

// Create absolute path to project root
const projectRoot = process.env.COMB_PROJECT_ROOT ? process.env.COMB_PROJECT_ROOT : (isAbsolute(argv.projectRoot) ? argv.projectRoot : normalize(join(process.cwd(), argv.projectRoot)));
const config = validateConfig(isAbsolute(argv.config) ? argv.config : normalize(join(projectRoot, argv.config)));

// First check the OS and Node.js and pnpm versions
checkOS();
checkNodeVersion();
checkPnpmVersion();

if (config.useGitlabPackageRegistry) {
  logger.info('🍱 Ensuring GitLab package registry applied for @hiveio-scoped packages');

  // TODO: Implement updating .npmrc with GitLab package registry
}
