import { nodeResolve } from '@rollup/plugin-node-resolve';
import commonjs from '@rollup/plugin-commonjs';
import json from '@rollup/plugin-json';

export default [
  {
    input: 'dist/src/index.js',
    output: {
      format: 'es',
      file: 'dist/bundle/index.js'
    },
    plugins: [
      nodeResolve({
        preferBuiltins: true,
        browser: false,
        resolveOnly: () => false
      }),
      json(),
      commonjs()
    ]
  }
];
