#!/usr/bin/env bash

SCRIPTPATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
PROJECT_DIR="${SCRIPTPATH}/.."

PUBLISH_TOKEN="${1}"
# @hiveio
SCOPE="${2:-@hiveio}"
# gitlab.syncad.com/api/v4/projects/419/packages/npm/
REGISTRY_URL="${3:-registry.npmjs.org/}"

PROJECT_NAME="workerbee"

git config --global --add safe.directory '*'

git fetch --tags

SHORT_HASH=$(git rev-parse --short HEAD)
REV_HASH=$(git rev-parse HEAD)
CURRENT_BRANCH_IMPL=$(git branch -r --contains "${SHORT_HASH}" | head -n 1)
if [ "${CURRENT_BRANCH_IMPL}" = "" ]; then
  CURRENT_BRANCH=$(git rev-parse --abbrev-ref HEAD)
else
  if [ " ${CURRENT_BRANCH_IMPL#*-> origin/} " = " ${CURRENT_BRANCH_IMPL} " ]; then
    CURRENT_BRANCH="${CURRENT_BRANCH_IMPL#*/}"
  else
    CURRENT_BRANCH="${CURRENT_BRANCH_IMPL#*-> origin/}"
  fi
fi
GIT_COMMIT_TIME=$(TZ=UTC0 git show --quiet --date='format-local:%Y%m%d%H%M%S' --format="%cd")
TAG_TIME=${GIT_COMMIT_TIME:2}
TAG=$(git tag --sort=-taggerdate | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+(-.+)?' | tail -1)

echo "Preparing npm packge for ${CURRENT_BRANCH}@${TAG} (#${SHORT_HASH})"

if [ "${TAG}" = "" ]; then
  echo "Could not find a valid tag name for branch"
  exit 1
fi

DIST_TAG=""
NEW_VERSION=""

if [ "$CURRENT_BRANCH" = "main" ]; then
  DIST_TAG="latest"
  NEW_VERSION="${TAG}"
elif [ "$CURRENT_BRANCH" = "develop" ]; then
  DIST_TAG="stable"
  NEW_VERSION="${TAG}-stable.${TAG_TIME}"
else
  DIST_TAG="dev"
  NEW_VERSION="${TAG}-${TAG_TIME}"
fi

echo> "${PROJECT_DIR}/.npmrc"

if [ "$REGISTRY_URL" != "registry.npmjs.org/" ]; then
  echo "${SCOPE}:registry=https://${REGISTRY_URL}" >> "${PROJECT_DIR}/.npmrc"
fi

echo "//${REGISTRY_URL}:_authToken=\"${PUBLISH_TOKEN}\"" >> "${PROJECT_DIR}/.npmrc"

git checkout "${PROJECT_DIR}/package.json" # be sure we're on clean version

jq ".name = \"${SCOPE}/${PROJECT_NAME}\" | .version = \"$NEW_VERSION\" | .publishConfig.registry = \"https://${REGISTRY_URL}\" | .publishConfig.tag = \"${DIST_TAG}\"" "${PROJECT_DIR}/package.json" > "${PROJECT_DIR}/package.json.tmp"

mv "${PROJECT_DIR}/package.json.tmp" "${PROJECT_DIR}/package.json"

# Display detailed publish config data
jq -r '.name + "@" + .version + " (" + .publishConfig.tag + ") " + .publishConfig.registry' "${PROJECT_DIR}/package.json"

sed -i "s/\${CommitSHA}/${REV_HASH}/g" README.md
