module.exports = {
  root: true,
  parser: "@typescript-eslint/parser",
  plugins: [
    "@typescript-eslint",
    "import"
  ],
  extends: [
    "eslint:recommended",
    "plugin:@typescript-eslint/recommended"
  ],
  env: {
    browser:  true,
    node:     false,
    commonjs: true,
    es6:      true
  },
  parserOptions: {
    ecmaVersion: 6,
    sourceType: "script",
    allowReserved: false,
    ecmaFeatures: {
      globalReturn:  false,
      impliedStrict: true,
      jsx:           false
    }
  },
  rules: {
    // Possible problems
    "no-constructor-return":           1,
    "array-callback-return":           1,
    "no-promise-executor-return":      1,
    "no-unreachable-loop":             1,
    "require-atomic-updates":          1,
    "no-duplicate-imports":            2,
    "no-template-curly-in-string":     2,
    "no-unused-private-class-members": 2,

    "@typescript-eslint/no-unused-vars": [ 1, { argsIgnorePattern: "^_", varsIgnorePattern: "^_" } ],
    "@typescript-eslint/explicit-member-accessibility": 2,
    "@typescript-eslint/explicit-function-return-type": 2,
    "@typescript-eslint/no-non-null-assertion": 0,
    "@typescript-eslint/no-inferrable-types": 0,

    // Suggestions
    "@typescript-eslint/no-namespace": 0,
    "@typescript-eslint/no-explicit-any": 0,
    "camelcase":                      0,
    "capitalized-comments":           1,
    "dot-notation":                   1,
    "multiline-comment-style":        1,
    "no-bitwise":                     1,
    "no-div-regex":                   1,
    "no-else-return":                 1,
    "no-extend-native":               1,
    "no-extra-label":                 1,
    "no-floating-decimal":            1,
    "no-label-var":                   1,
    "no-labels":                      1,
    "no-lone-blocks":                 1,
    "no-lonely-if":                   1,
    "no-new":                         1,
    "no-negated-condition":           1,
    "no-shadow":                      0,
    "@typescript-eslint/no-extra-semi": 0,
    "@typescript-eslint/no-empty-function": 0,
    "prefer-destructuring":           1,
    "prefer-template":                1,
    "curly":                        [ 1, "multi" ],
    "default-case":                 [ 1, { commentPattern: "^[sS]kip\\sdefault" } ],
    "@typescript-eslint/no-shadow":   2,
    "consistent-return":              0,
    "consistent-this":                2,
    "eqeqeq":                         2,
    "func-name-matching":             2,
    "func-names":                     2,
    "grouped-accessor-pairs":         2,
    "init-declarations":              0,
    "no-array-constructor":           2,
    "no-caller":                      2,
    "no-console":                     1,
    "no-eval":                        2,
    "no-implied-eval":                2,
    "no-extra-bind":                  2,
    "no-implicit-globals":            2,
    "no-mixed-operators":             2,
    "no-multi-str":                   2,
    "no-new-wrappers":                2,
    "no-new-object":                  2,
    "no-new-func":                    2,
    "no-proto":                       2,
    "no-return-await":                2,
    "no-throw-literal":               2,
    "no-unneeded-ternary":            2,
    "no-unused-expressions":          2,
    "no-useless-call":                2,
    "no-useless-computed-key":        2,
    "no-useless-concat":              2,
    "no-useless-rename":              2,
    "no-useless-return":              2,
    "no-var":                         2,
    "prefer-const":                   2,
    "prefer-numeric-literals":        2,
    "prefer-object-has-own":          2,
    "prefer-object-spread":           2,
    "prefer-promise-reject-errors":   2,
    "prefer-regex-literals":          2,
    "prefer-rest-params":             2,
    "prefer-spread":                  2,
    "require-await":                  2,
    "symbol-description":             2,
    "yoda":                           2,
    "spaced-comment":               [ 2, "always" ],
    "operator-assignment":          [ 2, "always" ],
    "func-style":                   [ 2, "expression" ],
    "no-return-assign":             [ 2, "except-parens" ],
    "no-sequences":                 [ 2, "allowInParentheses" ],
    "quote-props":                  [ 2, "consistent-as-needed" ],
    "prefer-arrow-callback":        [ 2, { allowNamedFunctions: true } ],
    "object-shorthand":             [ 2, "always", { avoidQuotes: true } ],
    "no-restricted-exports":        [ 2, { restrictedNamedExports: [ "default" ] } ],
    "no-restricted-syntax":         [ 2, "WithStatement", "BinaryExpression[operator='in']" ],
    "id-length":                    [ 2, { min: 2, max: 30, exceptionPatterns: [ "[ei-l]" ] } ],

    "@typescript-eslint/typedef": [
      2,
      {
        arrayDestructuring: false,
        objectDestructuring: false,
        arrowParameter: false,
        memberVariableDeclaration: true,
        parameter: true,
        propertyDeclaration: true,
        variableDeclaration: false,
        variableDeclarationIgnoreFunction: true
      }
    ],

    // Layout and formatting
    "eol-last":                          1,
    "no-multiple-empty-lines":           1,
    "rest-spread-spacing":               1,
    "semi":                              1,
    "space-before-blocks":               1,
    "wrap-regex":                        1,
    "space-infix-ops":                   1,
    "space-before-function-paren":     [ 1, "never" ],
    "array-bracket-spacing":           [ 1, "always" ],
    "block-spacing":                   [ 1, "always" ],
    "arrow-parens":                    [ 1, "as-needed" ],
    "function-call-argument-newline":  [ 1, "consistent" ],
    "array-bracket-newline":           [ 1, "consistent" ],
    "array-element-newline":           [ 1, "consistent" ],
    "max-len":                         [ 1, { code: 160 } ],
    "arrow-spacing":                   [ 1, { before: true, after: true } ],
    "semi-spacing":                    [ 1, { before: false, after: true } ],
    "keyword-spacing":                 [ 1, { before: true, after: false, overrides: {
      import: { after: true },
      export: { after: true },
      from: { after: true },
      const: { after: true },
      try: { after: true },
      catch: { after: true },
      do: { after: true },
      async: { after: true },
      return: { after: true },
      default: { after: true },
      finally: { after: true }
    } } ],
    "computed-property-spacing":       [ 1, "never", { enforceForClassMembers: false } ],
    "comma-dangle":                      2,
    "comma-spacing":                     2,
    "space-unary-ops":                   2,
    "switch-colon-spacing":              2,
    "generator-star-spacing":            2,
    "implicit-arrow-linebreak":          2,
    "linebreak-style":                   2,
    "lines-between-class-members":       2,
    "new-parens":                        2,
    "no-tabs":                           2,
    "no-trailing-spaces":                2,
    "no-whitespace-before-property":     2,
    "no-empty":                        [ 2, { allowEmptyCatch: true } ],
    "indent":                          [ 2, 2 ],
    "semi-style":                      [ 2, "last" ],
    "comma-style":                     [ 2, "last" ],
    "unicode-bom":                     [ 2, "never" ],
    "operator-linebreak":              [ 2, "before" ],
    "yield-star-spacing":              [ 2, "before" ],
    "wrap-iife":                       [ 2, "inside" ],
    "quotes":                          [ 2, "double" ],
    "newline-per-chained-call":        [ 2, { ignoreChainWithDepth: 2 } ],
    "key-spacing":                     [ 2, { beforeColon: false, mode: "minimum" } ],
    "brace-style":                     [ 2, "1tbs", { allowSingleLine: true } ],
    "padding-line-between-statements": [ 2, { blankLine: "always", prev: "*", next: "return" } ],

    "import/no-webpack-loader-syntax": 1,
    "import/no-self-import": 2,
    "import/no-cycle": 2,
    "import/no-useless-path-segments": 2,
    "import/no-relative-parent-imports": 1,
    "import/no-relative-packages": 1,
    "import/export": 2,
    "import/no-named-as-default": 1,
    "import/no-named-as-default-member": 1,
    "import/no-deprecated": 1,
    "import/no-extraneous-dependencies": 1,
    "import/no-mutable-exports": 2,
    "import/no-unused-modules": 1,
    "import/unambiguous": 2,
    "import/no-commonjs": 1,
    "import/no-amd": 1,
    "import/no-import-module-exports": 1,
    "import/no-unassigned-import": 0,
    "import/newline-after-import": 2,
    "import/first": 2,
    "import/exports-last": 0,
    "import/no-duplicates": 2,
    "import/no-namespace": 0,
    "import/order": [
      2,
      {
        alphabetize: {
          order: "asc",
          caseInsensitive: true
        }
      }
    ]
  }
};
