import { account_create } from "./account_create.js";
import { account_create_with_delegation } from "./account_create_with_delegation.js";
import { account_created } from "./account_created.js";
import { account_update } from "./account_update.js";
import { account_update2 } from "./account_update2.js";
import { account_witness_proxy } from "./account_witness_proxy.js";
import { account_witness_vote } from "./account_witness_vote.js";
import { author_reward } from "./author_reward.js";
import { cancel_transfer_from_savings } from "./cancel_transfer_from_savings.js";
import { change_recovery_account } from "./change_recovery_account.js";
import { changed_recovery_account } from "./changed_recovery_account.js";
import { claim_account } from "./claim_account.js";
import { claim_reward_balance } from "./claim_reward_balance.js";
import { clear_null_account_balance } from "./clear_null_account_balance.js";
import { collateralized_convert } from "./collateralized_convert.js";
import { collateralized_convert_immediate_conversion } from "./collateralized_convert_immediate_conversion.js";
import { comment } from "./comment.js";
import { comment_benefactor_reward } from "./comment_benefactor_reward.js";
import { comment_options } from "./comment_options.js";
import { comment_payout_update } from "./comment_payout_update.js";
import { comment_reward } from "./comment_reward.js";
import { consolidate_treasury_balance } from "./consolidate_treasury_balance.js";
import { convert } from "./convert.js";
import { create_claimed_account } from "./create_claimed_account.js";
import { create_proposal } from "./create_proposal.js";
import { curation_reward } from "./curation_reward.js";
import { custom } from "./custom.js";
import { custom_json } from "./custom_json.js";
import { decline_voting_rights } from "./decline_voting_rights.js";
import { declined_voting_rights } from "./declined_voting_rights.js";
import { delayed_voting } from "./delayed_voting.js";
import { delegate_vesting_shares } from "./delegate_vesting_shares.js";
import { delete_comment } from "./delete_comment.js";
import { dhf_conversion } from "./dhf_conversion.js";
import { dhf_funding } from "./dhf_funding.js";
import { effective_comment_vote } from "./effective_comment_vote.js";
import { escrow_approve } from "./escrow_approve.js";
import { escrow_approved } from "./escrow_approved.js";
import { escrow_dispute } from "./escrow_dispute.js";
import { escrow_rejected } from "./escrow_rejected.js";
import { escrow_release } from "./escrow_release.js";
import { escrow_transfer } from "./escrow_transfer.js";
import { expired_account_notification } from "./expired_account_notification.js";
import { failed_recurrent_transfer } from "./failed_recurrent_transfer.js";
import { feed_publish } from "./feed_publish.js";
import { fill_collateralized_convert_request } from "./fill_collateralized_convert_request.js";
import { fill_convert_request } from "./fill_convert_request.js";
import { fill_order } from "./fill_order.js";
import { fill_recurrent_transfer } from "./fill_recurrent_transfer.js";
import { fill_transfer_from_savings } from "./fill_transfer_from_savings.js";
import { fill_vesting_withdraw } from "./fill_vesting_withdraw.js";
import { hardfork } from "./hardfork.js";
import { hardfork_hive } from "./hardfork_hive.js";
import { hardfork_hive_restore } from "./hardfork_hive_restore.js";
import { ineffective_delete_comment } from "./ineffective_delete_comment.js";
import { interest } from "./interest.js";
import { limit_order_cancel } from "./limit_order_cancel.js";
import { limit_order_cancelled } from "./limit_order_cancelled.js";
import { limit_order_create } from "./limit_order_create.js";
import { limit_order_create2 } from "./limit_order_create2.js";
import { liquidity_reward } from "./liquidity_reward.js";
import { pow } from "./pow.js";
import { pow2 } from "./pow2.js";
import { pow_reward } from "./pow_reward.js";
import { producer_missed } from "./producer_missed.js";
import { producer_reward } from "./producer_reward.js";
import { proposal_fee } from "./proposal_fee.js";
import { proposal_pay } from "./proposal_pay.js";
import { proxy_cleared } from "./proxy_cleared.js";
import { recover_account } from "./recover_account.js";
import { recurrent_transfer } from "./recurrent_transfer.js";
import { remove_proposal } from "./remove_proposal.js";
import { request_account_recovery } from "./request_account_recovery.js";
import { return_vesting_delegation } from "./return_vesting_delegation.js";
import { set_withdraw_vesting_route } from "./set_withdraw_vesting_route.js";
import { shutdown_witness } from "./shutdown_witness.js";
import { system_warning } from "./system_warning.js";
import { transfer } from "./transfer.js";
import { transfer_from_savings } from "./transfer_from_savings.js";
import { transfer_to_savings } from "./transfer_to_savings.js";
import { transfer_to_vesting } from "./transfer_to_vesting.js";
import { transfer_to_vesting_completed } from "./transfer_to_vesting_completed.js";
import { update_proposal } from "./update_proposal.js";
import { update_proposal_votes } from "./update_proposal_votes.js";
import { vesting_shares_split } from "./vesting_shares_split.js";
import { vote } from "./vote.js";
import { withdraw_vesting } from "./withdraw_vesting.js";
import { witness_block_approve } from "./witness_block_approve.js";
import { witness_set_properties } from "./witness_set_properties.js";
import { witness_update } from "./witness_update.js";
export declare const protobufPackage = "hive.protocol.buffers";
/**
 * NOTE: do not change the order of any operations prior to the virtual operations
 * or it will trigger a hardfork.
 */
export interface operation {
    vote?: vote | undefined;
    comment?: comment | undefined;
    transfer?: transfer | undefined;
    transfer_to_vesting?: transfer_to_vesting | undefined;
    withdraw_vesting?: withdraw_vesting | undefined;
    limit_order_create?: limit_order_create | undefined;
    limit_order_cancel?: limit_order_cancel | undefined;
    feed_publish?: feed_publish | undefined;
    convert?: convert | undefined;
    account_create?: account_create | undefined;
    account_update?: account_update | undefined;
    witness_update?: witness_update | undefined;
    account_witness_vote?: account_witness_vote | undefined;
    account_witness_proxy?: account_witness_proxy | undefined;
    pow?: pow | undefined;
    custom?: custom | undefined;
    witness_block_approve?: witness_block_approve | undefined;
    delete_comment?: delete_comment | undefined;
    custom_json?: custom_json | undefined;
    comment_options?: comment_options | undefined;
    set_withdraw_vesting_route?: set_withdraw_vesting_route | undefined;
    limit_order_create2?: limit_order_create2 | undefined;
    claim_account?: claim_account | undefined;
    create_claimed_account?: create_claimed_account | undefined;
    request_account_recovery?: request_account_recovery | undefined;
    recover_account?: recover_account | undefined;
    change_recovery_account?: change_recovery_account | undefined;
    escrow_transfer?: escrow_transfer | undefined;
    escrow_dispute?: escrow_dispute | undefined;
    escrow_release?: escrow_release | undefined;
    pow2?: pow2 | undefined;
    escrow_approve?: escrow_approve | undefined;
    transfer_to_savings?: transfer_to_savings | undefined;
    transfer_from_savings?: transfer_from_savings | undefined;
    cancel_transfer_from_savings?: cancel_transfer_from_savings | undefined;
    decline_voting_rights?: decline_voting_rights | undefined;
    claim_reward_balance?: claim_reward_balance | undefined;
    delegate_vesting_shares?: delegate_vesting_shares | undefined;
    account_create_with_delegation?: account_create_with_delegation | undefined;
    witness_set_properties?: witness_set_properties | undefined;
    account_update2?: account_update2 | undefined;
    create_proposal?: create_proposal | undefined;
    update_proposal_votes?: update_proposal_votes | undefined;
    remove_proposal?: remove_proposal | undefined;
    update_proposal?: update_proposal | undefined;
    collateralized_convert?: collateralized_convert | undefined;
    recurrent_transfer?: recurrent_transfer | undefined;
    /** Virtual operations: */
    fill_convert_request?: fill_convert_request | undefined;
    author_reward?: author_reward | undefined;
    curation_reward?: curation_reward | undefined;
    comment_reward?: comment_reward | undefined;
    liquidity_reward?: liquidity_reward | undefined;
    interest?: interest | undefined;
    fill_vesting_withdraw?: fill_vesting_withdraw | undefined;
    fill_order?: fill_order | undefined;
    shutdown_witness?: shutdown_witness | undefined;
    fill_transfer_from_savings?: fill_transfer_from_savings | undefined;
    hardfork?: hardfork | undefined;
    comment_payout_update?: comment_payout_update | undefined;
    return_vesting_delegation?: return_vesting_delegation | undefined;
    comment_benefactor_reward?: comment_benefactor_reward | undefined;
    producer_reward?: producer_reward | undefined;
    clear_null_account_balance?: clear_null_account_balance | undefined;
    proposal_pay?: proposal_pay | undefined;
    dhf_funding?: dhf_funding | undefined;
    hardfork_hive?: hardfork_hive | undefined;
    hardfork_hive_restore?: hardfork_hive_restore | undefined;
    delayed_voting?: delayed_voting | undefined;
    consolidate_treasury_balance?: consolidate_treasury_balance | undefined;
    effective_comment_vote?: effective_comment_vote | undefined;
    ineffective_delete_comment?: ineffective_delete_comment | undefined;
    dhf_conversion?: dhf_conversion | undefined;
    expired_account_notification?: expired_account_notification | undefined;
    changed_recovery_account?: changed_recovery_account | undefined;
    transfer_to_vesting_completed?: transfer_to_vesting_completed | undefined;
    pow_reward?: pow_reward | undefined;
    vesting_shares_split?: vesting_shares_split | undefined;
    account_created?: account_created | undefined;
    fill_collateralized_convert_request?: fill_collateralized_convert_request | undefined;
    system_warning?: system_warning | undefined;
    fill_recurrent_transfer?: fill_recurrent_transfer | undefined;
    failed_recurrent_transfer?: failed_recurrent_transfer | undefined;
    limit_order_cancelled?: limit_order_cancelled | undefined;
    producer_missed?: producer_missed | undefined;
    proposal_fee?: proposal_fee | undefined;
    collateralized_convert_immediate_conversion?: collateralized_convert_immediate_conversion | undefined;
    escrow_approved?: escrow_approved | undefined;
    escrow_rejected?: escrow_rejected | undefined;
    proxy_cleared?: proxy_cleared | undefined;
    declined_voting_rights?: declined_voting_rights | undefined;
}
export declare const operation: {
    fromJSON(object: any): operation;
    toJSON(message: operation): unknown;
    create<I extends Exact<DeepPartial<operation>, I>>(base?: I): operation;
    fromPartial<I extends Exact<DeepPartial<operation>, I>>(object: I): operation;
};
type Builtin = Date | Function | Uint8Array | string | number | boolean | undefined;
export type DeepPartial<T> = T extends Builtin ? T : T extends globalThis.Array<infer U> ? globalThis.Array<DeepPartial<U>> : T extends ReadonlyArray<infer U> ? ReadonlyArray<DeepPartial<U>> : T extends {} ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : Partial<T>;
type KeysOfUnion<T> = T extends T ? keyof T : never;
export type Exact<P, I extends P> = P extends Builtin ? P : P & {
    [K in keyof P]: Exact<P[K], I[K]>;
} & {
    [K in Exclude<keyof I, KeysOfUnion<P>>]: never;
};
export {};
