"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class withdraw_vesting(google.protobuf.message.Message):
    """This operation converts Hive Power (also called Vesting Fund Shares or VESTS) into HIVE.
    At any given point in time an account can be withdrawing from their vesting shares.
    A user may change the number of shares they wish to cash out at any time between 0 and their total vesting stake.
    After applying this operation, vesting_shares will be withdrawn at a rate of vesting_shares/13 per week for 13 weeks
    starting one week after this operation is included in the blockchain.
    This operation is not valid if a user has no vesting shares.
    There can be only one withdraw_vesting_operation  processed at the same time.
    If a user wants to stop withdraw_vesting_operation, they should create an operation withdraw_vesting_operation with amount =0.
    If a user creates a new withdraw_vesting_operation when the old one is still processed,
    then the old withdraw_vesting_operation will be canceled and a new one will be processed.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/04_withdraw_vesting.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    VESTING_SHARES_FIELD_NUMBER: builtins.int
    account: builtins.str
    """@param {string} account - The account the funds are coming from."""
    @property
    def vesting_shares(self) -> asset_pb2.asset:
        """@param {asset} vesting_shares - Amount of VESTS (HP)"""
    def __init__(
        self,
        *,
        account: builtins.str | None = ...,
        vesting_shares: asset_pb2.asset | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["account", b"account", "vesting_shares", b"vesting_shares"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "vesting_shares", b"vesting_shares"]) -> None: ...

global___withdraw_vesting = withdraw_vesting
