"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class vote(google.protobuf.message.Message):
    """A user may upvote or downvote a post or a comment.

    A user has a voting power. The max voting power depends on HP.

    There are two manabars related to voting: Voting manabar and Downvoting manabar.
    Voting and downvoting manabars are defined as a percentage of total vote weight.
    Downvote manabar has 25% of the vote power weight and vote manabar has 100% of the vote power weight,
    but a user downvote with the total vote weight (not 25 %, but 100%).

    When a user casts a vote, 1/50th of the remaining mana is used for a 100% vote.
    The voting powers regenerate from 0 to 100% in 5 days (20% per day).

    If a voter casts another vote for the same post or comment before rewards are paid,
    it counts as vote edit. Vote edit cancels all effects of previous vote and acts as completely new vote,
    except mana used for previous vote is not returned.

    The author of the post or the comment may receive the reward,
    the amount of the author's reward depends on the numbers and powers of the votes.
    By default the author reward is paid 50% HP and 50 % HBD.

    A user who votes for the post or the comment may receive the curation reward. It is paid 100% HP. Its share depends on:
    - voting power
    - weight of the vote – a user may decide about the weight of the vote
    - the time when they vote – the sooner you vote, the higher the share in the curation reward (the first 24 h
      the weight of the vote is 100% - early voting, next 48 hours the weight is divided by 2, then – till the 7th day - it is divided by 8)

    When a post or a comment receives a reward, it is divided between the author's reward and the curation reward.
    The curation reward is shared among curators. 

    The calculated reward should be more than 0.02 HBD to be paid, if it is less, it is not paid.

    A downvoting user doesn’t receive the curation reward.
    Downvoting may affect the author of the comment's reputation when a user who downvotes has a higher reputation than the author.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/00_vote.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOTER_FIELD_NUMBER: builtins.int
    AUTHOR_FIELD_NUMBER: builtins.int
    PERMLINK_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    voter: builtins.str
    """@param {string} voter - Account name."""
    author: builtins.str
    """@param {string} author - Account name, the author of the post or the comment."""
    permlink: builtins.str
    """@param {string} permlink - The identifier of the post or comment."""
    weight: builtins.int
    """@param {number} weight - It defines how many percent of the non-used voting power a user wants to use. 
                             Allowed values from -10000 (-100%) to 10000 (100%).
                             Downvotes: from -10000 (-100%) to 0.
                             Upvotes: from 0 to 10000 (100%).
    """
    def __init__(
        self,
        *,
        voter: builtins.str | None = ...,
        author: builtins.str | None = ...,
        permlink: builtins.str | None = ...,
        weight: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["author", b"author", "permlink", b"permlink", "voter", b"voter", "weight", b"weight"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["author", b"author", "permlink", b"permlink", "voter", b"voter", "weight", b"weight"]) -> None: ...

global___vote = vote
