"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import builtins
import collections.abc
import future_extensions_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class recurrent_transfer_pair_id(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIR_ID_FIELD_NUMBER: builtins.int
    pair_id: builtins.int
    def __init__(
        self,
        *,
        pair_id: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pair_id", b"pair_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pair_id", b"pair_id"]) -> None: ...

global___recurrent_transfer_pair_id = recurrent_transfer_pair_id

@typing_extensions.final
class recurrent_transfer_extension(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOID_T_FIELD_NUMBER: builtins.int
    RECURRENT_TRANSFER_PAIR_ID_FIELD_NUMBER: builtins.int
    @property
    def void_t(self) -> future_extensions_pb2.void_t: ...
    @property
    def recurrent_transfer_pair_id(self) -> global___recurrent_transfer_pair_id: ...
    def __init__(
        self,
        *,
        void_t: future_extensions_pb2.void_t | None = ...,
        recurrent_transfer_pair_id: global___recurrent_transfer_pair_id | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extension", b"extension", "recurrent_transfer_pair_id", b"recurrent_transfer_pair_id", "void_t", b"void_t"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extension", b"extension", "recurrent_transfer_pair_id", b"recurrent_transfer_pair_id", "void_t", b"void_t"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["extension", b"extension"]) -> typing_extensions.Literal["void_t", "recurrent_transfer_pair_id"] | None: ...

global___recurrent_transfer_extension = recurrent_transfer_extension

@typing_extensions.final
class recurrent_transfer(google.protobuf.message.Message):
    """Creates/updates/removes a recurrent transfer in the currency Hive or HBD.
    Since HF 28, if user has more than one recurrent transfer to the same receiver
    or if user creates the recurrent transfer using pair_id in the extensions,
    user has to specify the pair_id in order to update or remove the defined recurrent transfer. 
    - If amount is set to 0, the recurrent transfer will be deleted and the virtual operation
      fill_recurrent_transfer_operation is not generated
    - If there is already a recurrent transfer matching 'from' and 'to', the recurrent transfer will be replaced, but:
    - If the 'recurrence' is not changed, the next execution will be according to “old definition” 
    - If the 'recurrence' is changed, then the next execution will be “update date” + 'recurrence' there is no execution on the update date. 
    - Up to HF28 there can be only one recurrent transfer for sender 'from' and receiver 'to'.
      Since H28 users may define more recurrent transfers to the same sender and receiver using pair_id in the 'executions'.
    - The one account may define up to 255 recurrent transfers to other accounts. 
    - The execution date of the last transfer should be no more than 730 days in the future.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/49_recurrent_transfer.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_ACCOUNT_FIELD_NUMBER: builtins.int
    TO_ACCOUNT_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    RECURRENCE_FIELD_NUMBER: builtins.int
    EXECUTIONS_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    from_account: builtins.str
    """@param {string} from_account"""
    to_account: builtins.str
    """@param {string} to_account - Account to transfer asset to. Cannot set a transfer to yourself."""
    @property
    def amount(self) -> asset_pb2.asset:
        """@param {asset} amount - The amount of asset to transfer from @ref from to @ref to.
                                If the recurrent transfer failed 10 (HIVE_MAX_CONSECUTIVE_RECURRENT_TRANSFER_FAILURES)
                                times because of the lack of funds, the recurrent transfer will be deleted.
                                Allowed currency: Hive and HBD.
        """
    memo: builtins.str
    """@param {string} memo - must be shorter than 2048."""
    recurrence: builtins.int
    """@param {number} recurrence - How often will the payment be triggered, unit: hours.
                                 The first transfer is executed immediately.
                                 The minimum value of the parameter is 24 h.
    """
    executions: builtins.int
    """@param {number} executions - How many times the recurrent payment will be executed.
                                 Executions must be at least 2, if you set executions to 1 the recurrent transfer will not be executed.
    """
    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___recurrent_transfer_extension]:
        """@param {recurrent_transfer_extension} extensions - Extensions. Since HF 28 it may contain the 'pair_id'.
                                                           It allows to define more than one recurrent transfer from sender to the same receiver 'to'. 
                                                           Default value 'pair_id=0'.
        """
    def __init__(
        self,
        *,
        from_account: builtins.str | None = ...,
        to_account: builtins.str | None = ...,
        amount: asset_pb2.asset | None = ...,
        memo: builtins.str | None = ...,
        recurrence: builtins.int | None = ...,
        executions: builtins.int | None = ...,
        extensions: collections.abc.Iterable[global___recurrent_transfer_extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["amount", b"amount", "executions", b"executions", "from_account", b"from_account", "memo", b"memo", "recurrence", b"recurrence", "to_account", b"to_account"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["amount", b"amount", "executions", b"executions", "extensions", b"extensions", "from_account", b"from_account", "memo", b"memo", "recurrence", b"recurrence", "to_account", b"to_account"]) -> None: ...

global___recurrent_transfer = recurrent_transfer
