"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class escrow_transfer(google.protobuf.message.Message):
    """The escrow allows the account { from_account } to send money to an account { to_account }
    only if the agreed terms will be fulfilled. In case of dispute { agent } may divide the funds
    between { from } and { to }. The escrow lasts up to { escrow_expiration }.
    When the escrow is created, the funds are transferred {from} to a temporary account.
    The funds are on the temporary balance, till the operation escrow_release_operation is created.
    To create an valid escrow:
    1. Sender { from } creates the escrow using the operation: escrow_transfer_operation indicated  { to } and { agent }.
    2. The { agent } and { to } have up to { ratification_deadline } for approving the escrow using operation: escrow_approve_operation.
    If there is a dispute, the operation: escrow_dispute_operation should be used.
    In case of the escrow releases, the operation: escrow_release_operation should be used.

    Descritpion https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/27_escrow_transfer.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_ACCOUNT_FIELD_NUMBER: builtins.int
    TO_ACCOUNT_FIELD_NUMBER: builtins.int
    AGENT_FIELD_NUMBER: builtins.int
    ESCROW_ID_FIELD_NUMBER: builtins.int
    HBD_AMOUNT_FIELD_NUMBER: builtins.int
    HIVE_AMOUNT_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    RATIFICATION_DEADLINE_FIELD_NUMBER: builtins.int
    ESCROW_EXPIRATION_FIELD_NUMBER: builtins.int
    JSON_META_FIELD_NUMBER: builtins.int
    from_account: builtins.str
    """@param {string} from_account - Account name."""
    to_account: builtins.str
    """@param {string} to_account - Account name."""
    agent: builtins.str
    """@param {string} agent - Account name."""
    escrow_id: builtins.int
    """@param {number} escrow_id - It is defined by the sender. It should be unique for { from }."""
    @property
    def hbd_amount(self) -> asset_pb2.asset:
        """@param {asset} hbd_amount - Escrow amount."""
    @property
    def hive_amount(self) -> asset_pb2.asset:
        """@param {asset} hive_amount - Escrow amount."""
    @property
    def fee(self) -> asset_pb2.asset:
        """@param {asset} fee - The fee amount depends on the agent. The fee is paid to the agent when approved."""
    ratification_deadline: builtins.str
    """@param {string} ratification_deadline - Time for approval for { to } and { agent }.
                                            If the escrow is not approved till { ratification_deadline },
                                            it will be rejected and all funds returned to { from }.
    """
    escrow_expiration: builtins.str
    """@param {string} escrow_expiration - See description of escrow_release_operation."""
    json_meta: builtins.str
    """@param {string} json_meta - json string."""
    def __init__(
        self,
        *,
        from_account: builtins.str | None = ...,
        to_account: builtins.str | None = ...,
        agent: builtins.str | None = ...,
        escrow_id: builtins.int | None = ...,
        hbd_amount: asset_pb2.asset | None = ...,
        hive_amount: asset_pb2.asset | None = ...,
        fee: asset_pb2.asset | None = ...,
        ratification_deadline: builtins.str | None = ...,
        escrow_expiration: builtins.str | None = ...,
        json_meta: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent", b"agent", "escrow_expiration", b"escrow_expiration", "escrow_id", b"escrow_id", "fee", b"fee", "from_account", b"from_account", "hbd_amount", b"hbd_amount", "hive_amount", b"hive_amount", "json_meta", b"json_meta", "ratification_deadline", b"ratification_deadline", "to_account", b"to_account"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent", b"agent", "escrow_expiration", b"escrow_expiration", "escrow_id", b"escrow_id", "fee", b"fee", "from_account", b"from_account", "hbd_amount", b"hbd_amount", "hive_amount", b"hive_amount", "json_meta", b"json_meta", "ratification_deadline", b"ratification_deadline", "to_account", b"to_account"]) -> None: ...

global___escrow_transfer = escrow_transfer
