import { KeychainKeyTypes, KeychainSDK } from "keychain-sdk";
import { IOnlineSignatureProvider } from "@hiveio/wax";

// XXX: Keychain does not allow custom chainId!!!
const keychain = new KeychainSDK(window);

export const createProvider = (async (accountName: string) => {
  return {
    async signTransaction(tx) {
      // XXX: Remember to handle keychain multisig transactions and proper `method`!
      const data = await keychain.signTx({
        method: KeychainKeyTypes.posting,
        username: accountName,
        tx: JSON.parse(tx.toLegacyApi())
      });

      for(const sig of data.result.signatures)
        tx.sign(sig);
    }
  } as IOnlineSignatureProvider;
});
