import { createHiveChain, OperationBase, type IOperationSink, type operation } from "@hiveio/wax";

const getN = () => "Oylz1DjbRx";
const generateTournament = () => "5ca24bbf92da6f69d749d2498919e9a04399063c";

export class SplinterlandsGame extends OperationBase {
  private readonly operations: operation[] = [];

  public constructor(
    public readonly player: string
  ) {
    super();
  }

  public finalize(_sink: IOperationSink): Iterable<operation> {
    return this.operations;
  }

  public enterTournament(): this {
    this.operations.push({
      custom_json: {
        id: "sm_enter_tournament",
        json: JSON.stringify({
          tournament_id: generateTournament(), // Custom string generated by the Splinterlands client
          signed_pw: null,
          app: "splinterlands/0.7.139",
          n: getN() // Custom string generated by the Splinterlands client
        }),
        required_auths: [],
        required_posting_auths: [
          this.player
        ]
      }
    });

    return this;
  }

  public stakeTokens(amount: number): this {
    this.operations.push({
      custom_json: {
        id: "sm_stake_tokens",
        json: JSON.stringify({
          qty: amount.toFixed(3),
          token: "SPS",
          app: "splinterlands/0.7.139",
          n: getN() // Custom string generated by the Splinterlands client
        }),
        required_auths: [],
        required_posting_auths: [
          this.player
        ]
      }
    });

    return this;
  }
}

const chain = await createHiveChain();
const tx = await chain.createTransaction();

const game = new SplinterlandsGame("username");
game.enterTournament().stakeTokens(10);
tx.pushOperation(game);

console.log(tx.transaction);
