"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import authority_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class account_create(google.protobuf.message.Message):
    """A new account may be created only by an existing account.
    The account that creates a new account pays a fee.
    The fee amount is set by the witnesses.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/09_account_create.md?ref_type=heads&plain=0&blame=1#2-parameters
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FEE_FIELD_NUMBER: builtins.int
    CREATOR_FIELD_NUMBER: builtins.int
    NEW_ACCOUNT_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    POSTING_FIELD_NUMBER: builtins.int
    MEMO_KEY_FIELD_NUMBER: builtins.int
    JSON_METADATA_FIELD_NUMBER: builtins.int
    @property
    def fee(self) -> asset_pb2.asset:
        """@param {asset} fee - Paid by creator. The witnesses decide the amount of the fee. Now, it is 3 HIVE."""
    creator: builtins.str
    """@param {string} creator - An account that creates a new account."""
    new_account_name: builtins.str
    """@param {string} new_account_name - Valid account name may consist of many parts separated by a dot,
                                     total may have up to 16 characters, parts have to start from a letter,
                                     may be followed by numbers, or '-'.
    """
    @property
    def owner(self) -> authority_pb2.authority:
        """@param {authority} owner"""
    @property
    def active(self) -> authority_pb2.authority:
        """@param {authority} active"""
    @property
    def posting(self) -> authority_pb2.authority:
        """@param {authority} posting"""
    memo_key: builtins.str
    """@param {string} memo_key - Not authority, public memo key."""
    json_metadata: builtins.str
    """@param {string} json_metadata"""
    def __init__(
        self,
        *,
        fee: asset_pb2.asset | None = ...,
        creator: builtins.str | None = ...,
        new_account_name: builtins.str | None = ...,
        owner: authority_pb2.authority | None = ...,
        active: authority_pb2.authority | None = ...,
        posting: authority_pb2.authority | None = ...,
        memo_key: builtins.str | None = ...,
        json_metadata: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["active", b"active", "creator", b"creator", "fee", b"fee", "json_metadata", b"json_metadata", "memo_key", b"memo_key", "new_account_name", b"new_account_name", "owner", b"owner", "posting", b"posting"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["active", b"active", "creator", b"creator", "fee", b"fee", "json_metadata", b"json_metadata", "memo_key", b"memo_key", "new_account_name", b"new_account_name", "owner", b"owner", "posting", b"posting"]) -> None: ...

global___account_create = account_create
