"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import authority_pb2
import builtins
import collections.abc
import future_extensions_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class account_update2(google.protobuf.message.Message):
    """There are two operations that allow updating an account data: account_update_operation and account_update2_operation.
    Operations account_update_operation and account_update2_operation share a limit of allowed updates
    of the owner authority  - two executions per 60 minutes (HIVE_OWNER_UPDATE_LIMIT) - meaning each of them
    can be executed twice or both can be executed once during that time period. 
    After 30 days (HIVE_OWNER_AUTH_RECOVERY_PERIOD) using the account recovery process to change the owner authority is no longer possible.
    The operation allows to update authority, json_metadata and the posting_json_metadata.
    Depending on what the user wants to change, a different authority has to be used.
    Each authority (owner, active, posting, memo_key) consists of:
    - weight_threshold
    - key or account name with its weight
    The authority may have more than one key and more than one assigned account name.

    @example Example 1:
    The posting authority:
    weight_threshold = 1
    'first_key', weight = 1
    'second_key', weight = 1
    'account_name_1', weight = 1
    The above settings mean that a user with 'first_key', a user with 'second_key' or a user 'account_name_1'
    may post on behalf of this account.

    @example Example 2:
    The posting authority:
    weight_threshold = 2
    'first_key', weight = 1
    'second_key', weight = 1
    'account_name_1', weight = 1
    The above settings mean that at least two signatures are needed to post on behalf of this account.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/43_account_update2.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    POSTING_FIELD_NUMBER: builtins.int
    MEMO_KEY_FIELD_NUMBER: builtins.int
    JSON_METADATA_FIELD_NUMBER: builtins.int
    POSTING_JSON_METADATA_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    account: builtins.str
    """@param {string} account - Account name, it cannot be updated."""
    @property
    def owner(self) -> authority_pb2.authority:
        """@param {authority} owner - Optional. In order to update the {owner}, the owner authority is required.
                                   It may be changed 2 times per hour.
                                   If a user provides a new authority, the old one will be deleted.
        """
    @property
    def active(self) -> authority_pb2.authority:
        """@param {authority} active - Optional. In order to update the {active}, the active authority is required.
                                    If a user provides a new authority, the old one will be deleted.
        """
    @property
    def posting(self) -> authority_pb2.authority:
        """@param {authority} posting - Optional. In order to update the {posting}, the active authority is required.
                                     If a user provides a new authority, the old one will be deleted.
        """
    memo_key: builtins.str
    """@param {string} memo_key - Optional. In order to update the {memo_key}, the active authority is required.
                               If a user provides a new key, the old one will be deleted.
    """
    json_metadata: builtins.str
    """@param {string} json_metadata - json_string; In order to update the {json_metadata}, the active authority is required."""
    posting_json_metadata: builtins.str
    """@param {string} posting_json_metadata - json_string; In order to update the { posting_json_metadata },
                                            the posting authority is required.
    """
    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[future_extensions_pb2.future_extensions]:
        """@param {future_extensions} extensions"""
    def __init__(
        self,
        *,
        account: builtins.str | None = ...,
        owner: authority_pb2.authority | None = ...,
        active: authority_pb2.authority | None = ...,
        posting: authority_pb2.authority | None = ...,
        memo_key: builtins.str | None = ...,
        json_metadata: builtins.str | None = ...,
        posting_json_metadata: builtins.str | None = ...,
        extensions: collections.abc.Iterable[future_extensions_pb2.future_extensions] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["account", b"account", "active", b"active", "json_metadata", b"json_metadata", "memo_key", b"memo_key", "owner", b"owner", "posting", b"posting", "posting_json_metadata", b"posting_json_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "active", b"active", "extensions", b"extensions", "json_metadata", b"json_metadata", "memo_key", b"memo_key", "owner", b"owner", "posting", b"posting", "posting_json_metadata", b"posting_json_metadata"]) -> None: ...

global___account_update2 = account_update2
