import pytest

from wax._private.core.formatters.underscore import underscore


@pytest.mark.parametrize("input_str, expected_output", [
    ("camelCaseExample", "camel_case_example"),
    ("CamelCaseExample", "camel_case_example"),
    ("camelCase", "camel_case"),
    ("CamelCase", "camel_case"),
    ("camel", "camel"),
    ("Camel", "camel"),
    ("camel2Case", "camel2_case"),
    ("Camel2Case", "camel2_case"),
    ("camelCase2Example", "camel_case2_example"),
    ("CamelCase2Example", "camel_case2_example"),
    ("camel2caseExample", "camel2case_example"),
    ("Camel2caseExample", "camel2case_example"),
    ("camelCaseExample2", "camel_case_example2"),
    ("CamelCaseExample2", "camel_case_example2"),
    ("camel2CaseExample2", "camel2_case_example2"),
    ("Camel2CaseExample2", "camel2_case_example2"),
    ("camel2caseExample2", "camel2case_example2"),
    ("Camel2caseExample2", "camel2case_example2"),
    ("camelCaseExampleExample", "camel_case_example_example"),
    ("CamelCaseExampleExample", "camel_case_example_example"),
    ("camelCaseExampleExample2", "camel_case_example_example2"),
    ("CamelCaseExampleExample2", "camel_case_example_example2"),
    ("camel2CaseExampleExample", "camel2_case_example_example"),
    ("Camel2CaseExampleExample", "camel2_case_example_example"),
    ("camel2caseExampleExample", "camel2case_example_example"),
    ("Camel2caseExampleExample", "camel2case_example_example"),
    ("camel2CaseExampleExample2", "camel2_case_example_example2"),
    ("Camel2CaseExampleExample2", "camel2_case_example_example2"),
    ("camel2caseExampleExample2", "camel2case_example_example2"),
    ("Camel2caseExampleExample2", "camel2case_example_example2"),
    ("exampleCamelCase", "example_camel_case"),
    ("ExampleCamelCase", "example_camel_case"),
    ("exampleCamelCase2", "example_camel_case2"),
    ("ExampleCamelCase2", "example_camel_case2"),
    ("example2CamelCase", "example2_camel_case"),
    ("Example2CamelCase", "example2_camel_case"),
    ("exampleCamelCaseExample", "example_camel_case_example"),
    ("ExampleCamelCaseExample", "example_camel_case_example"),
    ("exampleCamelCaseExample2", "example_camel_case_example2"),
    ("ExampleCamelCaseExample2", "example_camel_case_example2"),
    ("example2CamelCaseExample", "example2_camel_case_example"),
    ("Example2CamelCaseExample", "example2_camel_case_example"),
    ("example2CamelCaseExample2", "example2_camel_case_example2"),
    ("Example2CamelCaseExample2", "example2_camel_case_example2"),
    ("exampleCamelCaseExampleExample", "example_camel_case_example_example"),
    ("ExampleCamelCaseExampleExample", "example_camel_case_example_example"),
    ("exampleCamelCaseExampleExample2", "example_camel_case_example_example2"),
    ("ExampleCamelCaseExampleExample2", "example_camel_case_example_example2"),
    ("example2CamelCaseExampleExample", "example2_camel_case_example_example"),
    ("Example2CamelCaseExampleExample", "example2_camel_case_example_example"),
    ("example2CamelCaseExampleExample2", "example2_camel_case_example_example2"),
    ("VeryVeryLongAPI", "very_very_long_api"),
])
def test_camel_to_snake(input_str: str, expected_output: str) -> None:
    assert underscore(input_str) == expected_output
