"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class transfer_to_savings(google.protobuf.message.Message):
    """A user can place Hive and Hive Dollars into savings balances.
    Funds can be withdrawn from these balances after a three day delay.
    Keeping funds on the savings balance mitigates loss from hacked and compromised accounts.
    The maximum amount a user can lose instantaneously is the sum of what they hold in liquid balances.
    Assuming an account can be recovered quickly, loss in such situations can be kept to a minimum
    Additionally for keeping Hive Dollars on the savings balance, the interests are calculated.

    Description https://gitlab.syncad.com/hive/hive/-/blob/develop/doc/devs/operations/32_transfer_to_savings.md?ref_type=heads
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_ACCOUNT_FIELD_NUMBER: builtins.int
    TO_ACCOUNT_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    from_account: builtins.str
    """@param {string} from_account - The account the funds are coming from."""
    to_account: builtins.str
    """@param {string} to_account - The account the funds are going to.
                                 The funds may be transferred to someone else savings balance.
    """
    @property
    def amount(self) -> asset_pb2.asset:
        """@param {asset} amount - The allowed currency: HIVE and HBD, amount > 0."""
    memo: builtins.str
    """@param {string} memo - Have to be UTF8, must be shorter than 2048."""
    def __init__(
        self,
        *,
        from_account: builtins.str | None = ...,
        to_account: builtins.str | None = ...,
        amount: asset_pb2.asset | None = ...,
        memo: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["amount", b"amount", "from_account", b"from_account", "memo", b"memo", "to_account", b"to_account"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["amount", b"amount", "from_account", b"from_account", "memo", b"memo", "to_account", b"to_account"]) -> None: ...

global___transfer_to_savings = transfer_to_savings
