"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import asset_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class account_created(google.protobuf.message.Message):
    """Related to all acts of account creation, that is, creation of genesis accounts as well as operations:
    account_create_operation, account_create_with_delegation_operation, pow_operation, pow2_operation and create_claimed_account_operation.
    Generated every time one of above operations results in creation of new account (account is always created except for pow/pow2).
    Note: vops for genesis accounts are generated at the start of block #1.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEW_ACCOUNT_NAME_FIELD_NUMBER: builtins.int
    CREATOR_FIELD_NUMBER: builtins.int
    INITIAL_VESTING_SHARES_FIELD_NUMBER: builtins.int
    INITIAL_DELEGATION_FIELD_NUMBER: builtins.int
    new_account_name: builtins.str
    """@param {string} new_account_name - newly created account (receiver of initial_vesting_shares)"""
    creator: builtins.str
    """@param {string} creator - account that initiated new account creation (genesis and mined accounts are their own creators)"""
    @property
    def initial_vesting_shares(self) -> asset_pb2.asset:
        """@param {asset} initial_vesting_shares - (VESTS) amount of initial vesting on new account (converted from creation fee prior to HF20)"""
    @property
    def initial_delegation(self) -> asset_pb2.asset:
        """@param {asset} initial_delegation - (VESTS) amount of extra voting power on new account due to delegation"""
    def __init__(
        self,
        *,
        new_account_name: builtins.str | None = ...,
        creator: builtins.str | None = ...,
        initial_vesting_shares: asset_pb2.asset | None = ...,
        initial_delegation: asset_pb2.asset | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["creator", b"creator", "initial_delegation", b"initial_delegation", "initial_vesting_shares", b"initial_vesting_shares", "new_account_name", b"new_account_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["creator", b"creator", "initial_delegation", b"initial_delegation", "initial_vesting_shares", b"initial_vesting_shares", "new_account_name", b"new_account_name"]) -> None: ...

global___account_created = account_created
