## Contributing to Condenser

Everyone is welcome to contribute code to Hive projects. We have a Code of Conduct; we ask that you please follow it in all your interactions with our team and your fellow contributors.

### How to contribute

1. **Reporting Bugs**: If you encounter a bug or unexpected behavior, please file an issue to report it. Please include, if possible: a description of what happened, the URL of the page, the browser you're using, a screenshot of the bug or error message, and any relevant console output.
2. **Enhancement Suggestions**: If you have an enhancement suggestion, file an issue in this repo. Be clear in describing what problem you are trying to solve or the enhancement to existing functionality you’d like to see. Our team will review your issue and offer feedback, accept it for internal development, or recommend community development.
3. **Development Discussions**: Developers may open issues to discuss proposed changes. This is to inform the community of potential changes, and to get input from the community and other developers on the implementation.
4. **Pull Requests**: We love community contributions. If you've done some work on an issue and want to see it in the Condenser codebase, please submit a Pull Request, reference the issue in the description and start the title with `community -`. We're working very hard to keep our development practices as open as possible, and this helps us a lot. PRs which include tests, format code to existing conventions, and include documentation generally receive top priority.
   If one of our teammates asks you to make changes, please make them. All comments in code review must be resolved or addressed. Our teammates follow this rule too! And remember, you are agreeing to license your code and any intellectual property associated with your code under the same terms as the repository you are contributing to.

## Code of Conduct

Again, please note that this Code of Conduct only applies to our development presence.

### Our Pledge

We welcome your membership in our project and community under the rules that we have set below.

In the interest of fostering an open and welcoming environment, we as contributors and maintainers will work to make your participation in our project and community as fulfilling as possible.

### Our Rules

All members of our project and community must:

1. Show empathy toward other project and community members
2. Use welcoming and inclusive language
3. Respect differing viewpoints and experiences
4. Gracefully accept constructive criticism

All members of our project and community must not:

1. Harm our project and community, or advocate harm to our project and community
2. Insult or make derogatory comments about others
3. Interact with others after they have withdrawn permission to do so

### Our Responsibilities

We will use any and all lawful means at our disposal to enforce our rules. This includes but is not limited to:

1. Rejecting contributions
2. Removing comments, commits, code, wiki edits, and issues
3. Banning abusers

We will clarify standards of acceptable behavior and we will take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting us at github.abuse@hive.blog. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. We maintain strict confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org/), version 1.4, available at [http://contributor-covenant.org/version/1/4](http://contributor-covenant.org/version/1/4/gg)
