from __future__ import annotations

from typing import TYPE_CHECKING

from test_tools.__private.scope import context

if TYPE_CHECKING:
    from pathlib import Path


class ContextHandle:
    @staticmethod
    def get_current_directory() -> Path:
        """Returns path to directory where all files generated by TestTools' objects within current scope are stored."""
        return context.get_current_directory()


context_singleton = ContextHandle()
