## Cleanup policies

You can specify which files will be automatically removed when script finishes and cleanup is performed. Default behavior is:
- in automatic tests (running locally or in CI) -- unneeded files are removed (`tt.constants.CleanUpPolicy.REMOVE_ONLY_UNNEEDED_FILES`)
- in manual tests -- no clean up is performed (`tt.constants.CleanUpPolicy.DO_NOT_REMOVE_FILES`)

You can change this behavior for current scope (e.g. whole test function) or for selected node. For example, if you want to access some file removed by default when test will finish, (let's say -- block log or shared memory file, from node which is running in automatic test), you can do it in following way:
```python
import test_tools as tt
node.set_cleanup_policy(tt.constants.CleanUpPolicy.DO_NOT_REMOVE_FILES)
```

Then you have guarantee, that no files generated by this node will be removed.

To change cleanup policy within current scope:
```python
tt.cleanup_policy.set_default(tt.constants.CleanupPolicy.DO_NOT_REMOVE_FILES)
```
