import logging
import requests
import csv
import os
from tavern._core import exceptions
from tavern._plugins.rest.request import RestRequest
from time import perf_counter as perf
from uuid import uuid4
from json import dumps

logger = logging.getLogger(__name__)

class HivemindRequest(RestRequest):
    def run(self):
        try:
            start_time = perf()
            test_id = uuid4()
            file_name = os.getenv("HIVEMIND_BENCHMARKS_IDS_FILE", None)
            if file_name is not None:
                self._request_args['json']['id'] = str(test_id)
                with open(file_name, "a") as f:
                    writer = csv.writer(f)
                    writer.writerow([str(test_id), start_time, dumps(self._request_args['json'])])
            return self._prepared()
        except requests.exceptions.RequestException as e:
            logger.exception("Error running prepared request")
            raise exceptions.RestRequestException from e

