## Best Practices
The following should be considered and is recommended to establish marketing best practices for Hive. 

### Crypto Industry Norms
- Hype through airdrops, giveaways and promotions
- Charismatic founders team to conduct regular outreach events and speaker engagements
- Tight communities built around championing a coin, token or service
- Suppression of negative marketing and dissenting opinions within communities to create large echo chambers
- Constant flow of articles and press releases

Hive does not have a team of founders and is not interested in creating echo chambers. That removes two of the most prominent marketing options. The airdrop rounds have also concluded on Hive and are no longer relevant. However, Hive does have a strong and tight community built around it. Hive also has the ability to organize giveaways and promotions. Hive also has the ability to put out articles and press releases at regular intervals.

## Challenges

Hive is a decentralized project with no single leader or organizer. Several people have stepped forward to those roles but there remains the challenge of not having one ‘official’ point of contact. This is a positive challenge that is the direct result of decentralization; unfortunately, it does increase the complexity of forming cohesive marketing and promotional plans. 

- All marketing costs must either be sponsored/donated by individual Hive members or go through the DHF, where there is considerable effort to get a proposal approved
- Many of the key Hive stakeholders and active contributors are security and privacy-minded and unwilling to KYC their personal details to advertising portals
- Hive is a brand new venture and due to the lack of marketing done in regards to Hive’s predecessor, Steem, there is no tried and tested list of best practices that are known to guarantee positive results 

## SWOT Analysis

### Strengths
- Large, established and dedicated user-base
- No single point of absolute failure due to decentralization
- Growing DHF with a straight-forward proposal system that is transparent and must be used accountably by design

### Weaknesses
- Lack of central decision-making entity 
- Difficulties in securing and processing fiat for payments to vendors and various advertisement options
- Negative image inherited from the Steem days of ‘come make easy money for free’

### Opportunities
- First truly-decentralized DPoS blockchain story
- Crowdsourced social media marketing and promotion
- Second layer solutions can mitigate several Weaknesses

### Threats
- Apathy from news and outreach portals due to inability to deliver large bulk payments many cryptocurrency startups routinely pay
- Challenges in coordination due to decentralization



