## Outreach Methods

This section covers different outreach methods for Hive and evaluates them one by one.

## Strategic Collaborations 

Recognizing the mutual value in a strategic collaboration, even with a potential competitor, enables Hive to grow as an ecosystem. Other like-minded groups and organizations see the value and potential in Hive and the ideas it stands for. We are all part of a greater movement towards decentralization, independence, freedom and innovation. In that, we are more alike than different. 

Hive should strive to form strategic collaborations with fellow blockchain and cryptocurrency innovators that have the same far-reaching long-term vision rather than with those who are interested in a reciprocal short-term financial goal. Long-term partnerships will enable Hive to navigate uncharted territories while surrounded by allies. 

A strategic collaboration touches upon all of the target demographics. 

### Benefits of Strategic Collaborations

There are many possible benefits of joining forces with others: 

- Dedicated network of partners
- Mutually-beneficial relationship
- Sharing of promotional opportunities
- Sharing of marketing initiatives 
- Collaborative promotional ventures (conferences, hackathons, etc)
- Networking gateways
- Exclusive event invitations

The prime benefit of a strategic collaboration is diversity and bringing new opinions, approaches, experience, strengths and capabilities. 

### Collaborations as Event/Conference Sole-Sponsorships

Sponsoring both high-profile and smaller events, including online events that are common during pandemic times, helps get the brand name out. In most conferences, sponsors are provided with a package that guarantees so many mentions, an opportunity to present or speak, tickets, branding, handouts and giveaways, and many other ROI-based points. All professionally organized events will have a proper package set up for their sponsors that is meant to be beneficial and create a positive ROI. 

Hive should actively seek out professionally-organized events and sponsor them if costs are acceptable and the ROI is clearly presented. Technology events, particularly those to do with quantum computing, IoT, and any type of ‘disruptive technology’ are best and fit the Hive brand well. 

Events that have to do with political polarization, niche counter-scientific ideas and other matters that are not globally-inclusive, should be avoided. Those are best for individual dapps or communities on Hive to sponsor on their own but are not a good fit for the greater ecosystem due to our decentralized nature.

### Event/Conference Partnerships

Organizing an event in conjunction with a partner as a strategic collaboration, particularly a technology-focused event that can benefit all participants equally, would be an excellent way to promote Hive. Joint conferences bring in a wide variety of attendees and allow for a free mixing of ideas and innovative practices. 

Joint events are also much simpler to put on where the strengths of more than one core group are leveraged to ensure cohesive and proper organization. Costs are naturally less than putting on a sole event and marketing is greatly amplified in its reach. 

There are risks that have to be considered, many of them to do with competency and trust. The balance of work and investment should be equalized between contributors and the message has to be uniform to ensure a positive outcome for Hive, the partner, and most importantly for those attending. 
