## Batch 1
*Ref:* [Kyros Ventures AMA](https://hive.blog/hiveblockchain/@hiveio/hive-and-kyros-ventures-ama)

### Statement 1: 
Hive is decentralized and does not rely on a single point of income generation or project contribution to sustain itself; there is no core team or company to fund. Most of the work is driven more by passion for the principles and ideals of Hive as a medium of freedom of expression and exchange of ideas, than out of a drive for profit from coin appreciation. It's this same kind of idealism that has sustained Bitcoin through rough times.

Where funding is required, Hive developers either invest their own funds or leverage the Decentralized Hive Fund (DHF) proposal system to assist in financing their work. The DHF is essentially a proposal-based DPoS financing alternative which places the consensus behind direct financing into the hands of the Hive stakeholders. Investors can choose to support those projects that benefit the Hive ecosystem or generally promote the goals of Hive for a more free and egalitarian world.

### Statement 2: 
Our strategy for building a strong community is to empower our existing users and welcome new ones. One of our prime goals is to ensure accessibility for all. Everyone on Hive can partake in a wide range of activities. Those include blogging, participating in discussions, curating others, building and engaging with dapps, playing games and more; their limits are only constrained by their own imagination.

Hive recognizes that transaction fees are often one of the largest challenges to facilitating development and flexibility of use on a blockchain. Instead of requiring potentially costly and inconvenient transaction fees, Hive uses a novel stake-based Resource Credit mechanism to create a fee-less model. This directly translates to enabling any individual to join the Hive community in the way that is right for them; every member of the ecosystem is empowered to find their own success on Hive. It also directly correlates with strengthening our community and expanding our global reach.

### Statement 3:
Hive is not based in any specific jurisdiction and has nodes, stakeholders and contributors in many countries all over the globe. Hive is fully decentralized and as such is afforded special protection in the US, for instance, which honestly is closer to an acknowledgement it can't be stopped. This is simply one example of many and also serves as a key motivational factor for our existing community.

As far as security and privacy go, the Hive decentralized community is regularly monitoring for attacks. We have social features and funding mechanisms with an active and engaged community that have fended off an outlandish exchange hot-wallet voting attack that lead to the creation of Hive. Our users enjoy human readable accounts with different key levels, multi-sig, account recovery and memo keys that elevate PGP encryption to mitigate man-in-the-middle attacks. We have monitoring tools and processes in place to screen for phishing attempts of our users and assist them as possible should they fall victim to scammers. Our bases are covered, and our history is the proof.

### Statement 4:
We already had one Hackathon and will hold another one in due course. The first Hackathon raised over $4,000 USD and resulted in 14 new projects for Hive. Three of these projects received a portion of the prize pool, the winning project provides a massive improvement to Hive's onboarding process and is used by many Hive projects today. The second Hackathon is currently being prepared. Keep an eye on this site for updates: https://hivehackathon.com

### Statement 5: 
Hive uses a novel stake-based Resource Credit (RC) mechanism to create a fee-less model. As users use the chain more often they will consume more RCs, which automatically recharge daily. Dapp operators will be able to provide their users with free experiences on the chain by accumulating HIVE and then delegating their RCs to new users. This means that as the network grows, demand for RCs, and thereby demand for HIVE from operators grows with it. Hive also has a range of markets. Dapps focus on gaming, content platforms and NFTs for artists and content creators. These dapps on Hive have their own markets and marketing strategies for growth. In this way Hive focuses on many markets.

### Statement 6:
Hive has free transactions but no built-in smart contracts at this time. What we do have are developers that are taking our advantages and running with them. Layer 2 solutions that enable far more affordable and accessible DeFi have been proposed and are actively being developed. As it looks now, these solutions are secure and when compared to ETH, highly inexpensive. Everything from issuing NFTs to performing a swap will be more efficient and therefore more economical for creators and end-users. If you thought DeFi was hot when transactions cost $30 a piece, just wait until anybody in the world can afford to run them.

One of the dapps built on Hive, 3speak, is developing a service infrastructure pool (SIP), which is essentially a DeFi pool that takes in payments for services (such as video infrastructure), locks them in the pool forever so that it continuously grows and uses the earnings it makes in DeFi fees to pay out users running nodes that provide the service. The SIP model will likely be rolled out for various service types. The first service will be decentralised video infrastructure on the hive block chain.

Hive Engine is a Layer 2 smart contract platform already built on top of the Hive blockchain. The mission of the company is to make Hive the best and easiest place to start a block chain business. To accomplish their mission they enable easy creation of fungible and nonfungible tokens, and empower them with no-code, easy to use, configurable business logic smart contracts. Hive Engine is expecting to further decentralize their smart contract platform in the near future with a P2P Witness System. In addition, they are planning on introducing Uniswap-style liquidity pools and algorithmic stable coins to kickstart the decentralized finance revolution on the Hive blockchain.

### Statement 7:
The Hive blockchain is a fast, fee-less, scalable solution for a decentralized web. Investors, developers and end users meet in a robust, engaged community where the HIVE token allows near instantaneous transaction of value and wallet addresses are usernames that unlock an entire ecosystem of services.

For the investor, HIVE is a cryptocurrency unfettered by long wait times or hefty fees. Move value quickly without eating into your funds! Three second block times on a network producing some of the highest recorded daily transaction numbers at a minimum resource utilization meet easy to remember customizable wallet addresses, the ability to include end to end encrypted memos with transfers, and multiple options (tiered keys and staking) for holding and accessing funds safely from anywhere.

Hive boasts some of the largest communities and blockchain apps in the world. Games like Splinterlands are consistently ranked #1 for gaming across a variety of established blockchain app ranking sites. Leo Finance is a thriving tokenized community that reached a market cap of over 2 million with just its token. Hive is also among the top actively used blockchains in the world, and we are backed by real users interacting with the blockchain every day. Hive is a community that produces communities, and Hive offers all the tools someone would need to grow a thriving Web 3.0 ecosystem.

### Statement 8:
Hive was created as an independent and decentralized fork of the Steem blockchain. In early 2020, the Steem community which was established on the values of decentralization found itself facing a hostile takeover by the Tron Foundation following the sudden sale of the founding company, Steemit Inc, to Justin Sun. Steemit Inc's disproportionate influence on the public Steem blockchain was originally kept in check by a social contract. When the social contract was broken and a 51% Attack (a DPOS-based attack) was launched, the established community abandoned the now-centralized Steem and created Hive. Hive is an example of a grass-roots community that shares the core values of decentralization and freedom coming together to stand up to corporations and win. With this, Hive truly is the blockchain for Web 3.0.

### Statement 9:
We value all outreach and marketing opportunities for Hive and are constantly looking for venues to tell our story and share our ecosystem with others. In December we held our virtual HiveFest annual event. There is a Hackathon and other initiatives coming up that will be announced when finalized. We are regularly engaged in collaborative outreach opportunities, such as this excellent AMA, and welcome all connections.

Hive is always open to strategic collaborations with those who share our goals and values. Recognizing the mutual value in a strategic collaboration enables Hive to grow as an ecosystem. Other like-minded groups and organizations see the value and potential in Hive and the ideas it stands for. We are all part of a greater movement towards decentralization, independence, freedom and innovation. In that, we are more alike than different.

Our current relationships include our many prominent exchanges, listing sites, collaborations with MarketSquare/Ark blockchain, service providers such as GetBlock, and of course Kyros Ventures/Coin68.

### Statement 10:
Hive is mainly an online project. That said previously, Hive-users with feel for marketing would have attended blockchain industry events and for example game conferences. With Covid-19 these have come to a halt. The annual HiveFest which before saw 4 IRL editions in Europe and Asia was about to be cancelled but has then been "relocated" to virtual reality with a 400% visitor increase as a result (compared to past year's IRL conference in Bangkok, Thailand, 200% compared to ATH visitor numbers of Krakow 2018).

Hive is perfectly poised to support Layer 2 solutions and already has some built on it. We've addressed DeFi in our answer to question 5 but will touch on it further.

As Hive is composed of many dapps and communities, there have been numerous innovative approaches to DeFi on Hive. The Leo Finance community token, wLEO, is another token that can be wrapped and staked in DeFi pools on Ethereum. This token has shown strong growth and has several million dollars are currently staked. Another important up-and-coming system is called DLUX, which will encompass DeFi and smart contracts with open source development. The Hive ecosystem in general is rounded out by teams like Blocktrades looking to create further robust second layer infrastructure to help support all types of development needs.

## Batch 2:
*Ref:* [Huobi Global Joint AMA](https://hive.blog/hiveblockchain/@hiveio/huobi-global-official-hive-listing-announcement-giveaways-ama-chat-transcripts)

### Statement 1:
Hive is a Graphene-based social blockchain launched on 03/20/2020 with the core idea of decentralization. Hive's prime selling points are its true decentralization, speed and scalability. Other notable features include it having the lowest entry-barrier for user adoption in the market, time delay security, integrated token allocation, and the upcoming Smart Media Token integration. It is an ideal building location for a variety of innovative projects focused on a broad range of fields, from open source development to social games. Hive aims to be the preferred blockchain for dApp development.

### Statement 2:
Hive is a truly grassroots example of a decentralized proof of stake (dpos) blockchain with a concrete and proven utility as a social media and app-centric ecosystem. Hive has already proven itself to be attractive for non technical people, which is quite a feature in the blockchain world. It also boasts some of the fastest transaction blocktimes (3 seconds only). There is also a substantial decentralized hive fund which allows for continuous growth of the development of the chain and the dapps building on the blockchain.

### Statement 3:
Although Hive initially launched as a social media blockchain, and continues to strive to do so, more and more external (d)apps use the network. Not only to connect to the Hive content reward mechanism but also to utilize the 3 second fast blocktime and near instant confirmation (irreversibility after 1 minute) for an array of apps. With its flexible and easy to use, recognizable RESTfull APIs it is a breeze to implement a Hive integration to any app, whether it’s a utility, gaming, or in the social sphere. With the continued development on Smart Media Tokens, the Hive chain will cater to those other (d)app projects willing to launch a token-based reward system, which runs on the Hive network. As a result, Hive has a wide range of utility and organic growth. It also has the increased security that comes from a truly open source and public blockchain, where all stakeholders have a say in its direction. It sports resilience by design from the exit scams and other similar issues affecting the Altcoin community.

### Statement 4:
Did you know that Hive does already have more than 1.3 million wallets? The cool thing is those wallets are named accounts, not some randomized string. Your username is your wallet address! Hive has proven to be an entry point into the cryptoworld for many through its ease of use and plethora of apps available for using.

The Hive developer ecosystem came up with an array of open source native desktop apps, mobile apps, and browser plugins to take away the “hassle” of safely & securely handling and storing private keys. Lowering this entry barrier of user growth, combined with fast block times and free transactions results in adoption of the blockchain by new (d)apps every day. This is a positive spiral upwards!

### Statement 5:
Hive is projected to remain a decentralized community effort with no sole official representation. Instead, community groups have and are projected to organically form and lead the promotion of Hive. Informally, there are already companies and umbrella groups and collaborations working on marketing and code. There are also volunteers producing posts and events like this AMA. The Hive proposal system and passionate members of the ecosystem will band together to drive grassroots or professional marketing initiatives. Additionally, in an ecosystem where anyone can build anything and the blockchain is the skeleton that allows businesses, projects, services and dapps to flesh out their ideas, marketing Hive goes hand in hand with marketing the ventures. 

### Statement 6:
The ultimate goal of Hive is to flourish as a decentralized ecosystem that can support and provide an outlet for the voices and needs of a global userbase and audience. This is being achieved by:

- having a unique content rewards and curation model to build upon
- a user friendly crypto wallet with easy login flow for signing on users to (d)apps
- versatile “custom JSON” blockchain object storage API.
- and not to forget; fast 3 second blocktimes to get transactions executed within acceptable waiting time (1.5 seconds on average).

So far it’s been proven that Hive can be used for a wide variety of dapps. Ultimately the goal is to create a decentralized ecosystem that is used by an ever increasing amount of dapps and users. This has it’s challenges of course, but a lot of passionate people work day in day out on improving the Hive network.

### Statement 7:
There is no "team". Hive is a decentralized community who wanted to move forward. Hive was originally developed as a fork of the Steem blockchain. It was created on March 20th, 2020 as a community-driven fork. The vision behind it was to continue the strong community values that have been established while also freeing the formerly Steem-based ecosystem from the burden of Steemit Inc’s influence.

### Statement 8:
Hive has an active userbase and mature infrastructure for building dApps. One of Hive’s primary use-cases, social media, does not require complex integration with real-world players.

Onboarding the masses is more natural because the masses use familiar interfaces. The dApp ecosystem is innovating targeted products for niche audiences that do not require users to understand blockchain jargon. In business terms, with a large userbase comes opportunities for synergistic monetization, and this bodes well for future token value! Bringing full ownership and control to its own community creates a unique environment where the network is owned by all. This drives passion for the network.

We have seen this in the launch of the network and the past month with many (d)app owners converting to Hive and a fired up development cycle with a code freeze for the first hardfork already on it’s way. The amount of devs working on the core software and related libraries 20 folded compared to the old chain state. These “owners of Hive”, all token holders, are in it for the long term themselves. By already being active on the chain for 4 years, they did not want its values to be lost under a central entity and hence poured money, time and resources to make its creation and continuation a success. Once someone is part owner, it makes one dedicate more time and talent in their own “baby”.

### Statement 9:
There are two parts to [keeping developers attracted to Hive]; making it even easier for developers and incentivizing them to develop on Hive.

The main interface for dApps is via JSON RESTfull API nodes, and there are mature libraries for popular languages such as javascript, python, java. The community is continuously working on improving documentation, simplifying libraries and providing tutorials via the GitLab repositories. Hive has existing ways to incentivize developers:
- Developers can create funding proposals for the Hive Fund which are voted upon by the stakeholders.
- Developers can post about their activity and receive social media rewards.
- A big userbase can be flipped to use your project once you offer "Hive login"
- Additionally, developers might see value in contributing to a decentralized world. dApp developers that create frontends have unique monetization opportunities to reward their investment of time and skill.

New developers can follow community provided tutorials, which makes Hive an excellent choice for learning how to program for a blockchain. https://developers.hive.io/ for all docs!

### Statement 10:
There is no "hired" Hive development team; instead, there is a decentralized group of experienced developers who are contributing and working on a regular basis, keeping a similar pace to a traditional dev team. Many of them are the people who have built the Steem blockchain that Hive is forked on and have been part of development of Graphene projects for nearly half a decade.