# coding=utf-8
import sys
import os

from setuptools import find_packages
from setuptools import setup
from setuptools.command.install import install

assert sys.version_info[0] == 3 and sys.version_info[1] >= 6, "hive requires Python 3.6 or newer"

VERSION = '0.0.1'

class InstallWrapper(install):
    _GIT_REVISION = None
    def run(self):
        self._GIT_REVISION = self._get_git_version()
        self._save_version_file()
        install.run(self)

    def _get_git_version(self):
        if os.path.exists(".git"):
            from subprocess import check_output
            command = 'git describe --tags --long --dirty'
            version = check_output(command.split()).decode('utf-8').strip()
            parts = version.split('-')
            _, _, sha = parts[:3]
            return sha.lstrip('g')
        return self._get_git_version_from_file()

    def _get_git_version_from_file(self):
        with open("hive/version.py", 'r') as version_file:
            lines = version_file.readlines()
            _, git_version = lines[-1].split('=')
            return git_version.strip()

    def _save_version_file(self):
        with open("hive/version.py", 'w') as version_file:
            version_file.write("# generated by setup.py\n")
            version_file.write("# contents will be overwritten\n")
            version_file.write("VERSION = '{}'\n".format(VERSION))
            version_file.write("GIT_REVISION = '{}'".format(self._GIT_REVISION))

# yapf: disable
setup(
    name='hivemind',
    version_format=VERSION + "+{gitsha}",
    description='Developer-friendly microservice powering social networks on the Steem blockchain.',
    long_description=open('README.md').read(),
    packages=find_packages(exclude=['scripts']),
    setup_requires=['pytest-runner', 'setuptools-git-version', 'tox'],
    dependency_links=[
      'https://github.com/bcb/jsonrpcserver/tarball/8f3437a19b6d1a8f600ee2c9b112116c85f17827#egg=jsonrpcserver-4.1.3+8f3437a'
    ],
    install_requires=[
        #'aiopg==0.16.0',
        'aiopg @ https://github.com/aio-libs/aiopg/tarball/862fff97e4ae465333451a4af2a838bfaa3dd0bc',
        'jsonrpcserver @ https://github.com/bcb/jsonrpcserver/tarball/8f3437a19b6d1a8f600ee2c9b112116c85f17827#egg=jsonrpcserver',
        'simplejson',
        'aiohttp',
        'certifi',
        'sqlalchemy',
        'funcy',
        'toolz',
        'maya',
        'ujson',
        'urllib3',
        'psycopg2-binary',
        'aiocache',
        'configargparse',
        'pdoc',
        'diff-match-patch',
    ],
    entry_points={
        'console_scripts': [
            'hive=hive.cli:run',
        ]
    },
    cmdclass={'install': InstallWrapper}
)
