#!/bin/bash

set -e

pip install tox

export HIVEMIND_ADDRESS=$1
export HIVEMIND_PORT=$2
TEST_GROUP=$3
JUNITXML=$4
JOBS=${5:-auto}
export TAVERN_DIR="tests/tests_api/hivemind/tavern"

echo "Starting tests on hivemind server running on ${HIVEMIND_ADDRESS}:${HIVEMIND_PORT}"

echo "Selected test group (if empty all will be executed): $TEST_GROUP"

tox -e tavern -- \
    -W ignore::pytest.PytestDeprecationWarning \
    -n $JOBS \
    --junitxml=../../../../$JUNITXML $TEST_GROUP
