from hive.server.condenser_api.methods import _get_content_impl, _get_content_replies_impl
from hive.server.common.helpers import (
    return_error_info,
    valid_account,
    valid_permlink)
from hive.server.database_api.methods import find_votes_impl, VotesPresentation

@return_error_info
async def get_discussion(context, author: str, permlink: str, observer=None):
    db = context['db']
    return await _get_content_impl(db, False, author, permlink, observer)

@return_error_info
async def get_content_replies(context, author: str, permlink: str):
    db = context['db']
    return await _get_content_replies_impl(db, False, author, permlink)

