DROP TYPE IF EXISTS hivemind_app.condenser_api_post_ex CASCADE;
-- type for fat node style post of get_content()
CREATE TYPE hivemind_app.condenser_api_post_ex AS (
    id INT,
    author VARCHAR(16),
    permlink VARCHAR(255),
    author_rep BIGINT,
    title VARCHAR(512),
    body TEXT,
    category VARCHAR(255),
    depth SMALLINT,
    promoted DECIMAL(10,3),
    payout DECIMAL(10,3),
    pending_payout DECIMAL(10,3),
    payout_at TIMESTAMP,
    is_paidout BOOLEAN,
    children INT,
    votes INT,
    created_at TIMESTAMP,
    updated_at TIMESTAMP,
    rshares NUMERIC,
    abs_rshares NUMERIC,
    json TEXT,
    is_hidden BOOLEAN,
    is_grayed BOOLEAN,
    total_votes BIGINT,
    net_votes BIGINT,
    total_vote_weight NUMERIC,
    parent_author VARCHAR(16),
    parent_permlink_or_category VARCHAR(255),
    curator_payout_value VARCHAR(30),
    root_author VARCHAR(16),
    root_permlink VARCHAR(255),
    max_accepted_payout VARCHAR(30),
    percent_hbd INT,
    allow_replies BOOLEAN,
    allow_votes BOOLEAN,
    allow_curation_rewards BOOLEAN,
    beneficiaries JSON,
    url TEXT,
    root_title VARCHAR(512),
    active TIMESTAMP,
    author_rewards BIGINT,
    muted_reasons INTEGER
);
