/*
 * Copyright (c) 2015 Cryptonomex, Inc., and contributors.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#pragma once
#include <stdint.h>

namespace fc
{
class mutable_variant_object;
} ///namespace fc

namespace hive { namespace utilities {

/// Points git revision of root project (in case Hive project is embedded i.e. inside HAF)
extern const char* const root_project_git_revision_sha;
/// Points a name of root project (in case Hive project is embedded i.e. inside HAF)
extern const char* const root_project_name;
/// Points always a name of Hive projet
extern const char* const hive_project_name;

/// Points a Hive project git revision
extern const char* const git_revision_sha;
extern const uint32_t git_revision_unix_timestamp;
extern const char* const git_revision_description;

void build_version_info(fc::mutable_variant_object* storage);

} } // end namespace hive::utilities
