
What is an Automated Action
---------------------------

The concept of automatic/automated actions in the Hive Blockchain is not new to SMTs. The framework is a formalization of a design pattern that is already used widely in the Hive source code. When a user initiates a power down, a week later some Hive Power is converted to HIVE and deposited in their account. This is all done behind the scenes in what we have called per-block processing. The only artifacts of the state change are the changed balance in the account object and a virtual operation in the user's account history. The virtual operation is an annotation that the event occurred, but it does not represent the state transition itself. This has lead to inconsistencies in what data is included in each virtual operation. Automated Actions seek to fix this problem for all new such actions added in SMTs. Automated Actions not only represent but also trigger the state transition instead of simply recording such a transition occurred. Because they trigger transitions they must be included in blocks. The advantage of recording automated actions in such a manner is that while reindexing the blockchain, the actions can be trusted without verifying state. Well formed actions read minimal or no state and reduce reindex time.

Types of Actions
----------------

Automated Actions are broken in to two broad types of actions; required and optional. Required actions, as their name implies, are required to be included in blocks and verified trustlessly by each node running hived. Optional actions, likewise, are not required to be included. This is a new use case from what currently happens during per-block processing. What happens during per-block processing takes the state as input and transitions to a new state. This must be deterministic in order to avoid forking. Optional actions allows skipping of certain actions through the omission of their inclusion. One such example of how this is used is token emission for SMTs. SMTs must pay for token emissions via Resource Credits the same as users and their operations. Optional actions will be excluded during block generation based on RCs. This would not have previously been possible.

Required Actions
----------------

There are few rules governing required actions that makes block generation and validation easier.

All nodes track what required actions are expected and apply them in lock step with a incoming blocks. The order of inclusion of required actions is deterministic and blocks *must* include required actions in the same order that they are generated by the local node. Failure to do so could result in a different state and so blocks are pre-emptively rejected via consensus if they fail to include required actions in the correct order.

All required actions have an execution time associated with them and can only be included when the execution time is less than or equal to the head block time. Pending required actions are paginated by execution time and within each execution time are in FIFO order.

Required actions have 25% of the block size reserved for their inclusion. They can use more than 25% of the block space but anything beyond 25% will allow the required actions to be delayed to the next block. Because of this requirement, block generation has been tweaked to only fill up transactions to 75% of the block size. The partition percentage can be tweaked in a future hardfork if needed and witnesses can increase the max block size to compensate in the meantime.

Optional Actions
----------------

The requirements on optional actions or much more lax. Because they can be skipped, optional actions can be included in any order. This does put a little more responsibility in the hands of the developers to do proper verification for inclusion. Optional actions are added to a block after required actions and may not be included at all if there is no block space. Such behavior should be accounted for when designing optional actions. In our reference implementation for optional actions, pending optional actions will be removed from state after their execution time is equal to or earlier than the last irreversible block's block time.

Example Actions
---------------

TODO: Add some SMT Actions
