module Hive::Fallback
  API_METHODS = {
    account_by_key_api: [
      :get_key_references
    ],
    block_api: [
      :get_block,
      :get_block_header
    ],
    condenser_api: [
      :broadcast_block,
      :broadcast_transaction,
      :broadcast_transaction_synchronous,
      :get_account_count,
      :get_account_history,
      :get_account_references,
      :get_account_reputations,
      :get_account_votes,
      :get_accounts,
      :get_active_votes,
      :get_active_witnesses,
      :get_block,
      :get_block_header,
      :get_blog,
      :get_blog_authors,
      :get_blog_entries,
      :get_chain_properties,
      :get_comment_discussions_by_payout,
      :get_config,
      :get_content,
      :get_content_replies,
      :get_conversion_requests,
      :get_current_median_history_price,
      :get_discussions_by_active,
      :get_discussions_by_author_before_date,
      :get_discussions_by_blog,
      :get_discussions_by_cashout,
      :get_discussions_by_children,
      :get_discussions_by_comments,
      :get_discussions_by_created,
      :get_discussions_by_feed,
      :get_discussions_by_hot,
      :get_discussions_by_promoted,
      :get_discussions_by_trending,
      :get_discussions_by_votes,
      :get_dynamic_global_properties,
      :get_escrow,
      :get_expiring_vesting_delegations,
      :get_feed,
      :get_feed_entries,
      :get_feed_history,
      :get_follow_count,
      :get_followers,
      :get_following,
      :get_hardfork_version,
      :get_key_references,
      :get_market_history,
      :get_market_history_buckets,
      :get_next_scheduled_hardfork,
      :get_open_orders,
      :get_ops_in_block,
      :get_order_book,
      :get_owner_history,
      :get_post_discussions_by_payout,
      :get_potential_signatures,
      :get_reblogged_by,
      :get_recent_trades,
      :get_recovery_request,
      :get_replies_by_last_update,
      :get_required_signatures,
      :get_reward_fund,
      :get_savings_withdraw_from,
      :get_savings_withdraw_to,
      :get_state,
      :get_tags_used_by_author,
      :get_ticker,
      :get_trade_history,
      :get_transaction,
      :get_transaction_hex,
      :get_trending_tags,
      :get_version,
      :get_vesting_delegations,
      :get_volume,
      :get_withdraw_routes,
      :get_witness_by_account,
      :get_witness_count,
      :get_witness_schedule,
      :get_witnesses,
      :get_witnesses_by_vote,
      :lookup_account_names,
      :lookup_accounts,
      :lookup_witness_accounts,
      :verify_account_authority,
      :verify_authority,
      :find_proposals,
      :list_proposal_votes,
      :list_proposals
    ],
    database_api: [
      :find_account_recovery_requests,
      :find_accounts,
      :find_change_recovery_account_requests,
      :find_comments,
      :find_decline_voting_rights_requests,
      :find_escrows,
      :find_limit_orders,
      :find_owner_histories,
      :find_savings_withdrawals,
      :find_sbd_conversion_requests,
      :find_vesting_delegation_expirations,
      :find_vesting_delegations,
      :find_votes,
      :find_withdraw_vesting_routes,
      :find_witnesses,
      :get_active_witnesses,
      :get_config,
      :get_current_price_feed,
      :get_dynamic_global_properties,
      :get_feed_history,
      :get_hardfork_properties,
      :get_order_book,
      :get_potential_signatures,
      :get_required_signatures,
      :get_reward_funds,
      :get_transaction_hex,
      :get_version,
      :get_witness_schedule,
      :list_account_recovery_requests,
      :list_accounts,
      :list_change_recovery_account_requests,
      :list_comments,
      :list_decline_voting_rights_requests,
      :list_escrows,
      :list_limit_orders,
      :list_owner_histories,
      :list_savings_withdrawals,
      :list_sbd_conversion_requests,
      :list_vesting_delegation_expirations,
      :list_vesting_delegations,
      :list_votes,
      :list_withdraw_vesting_routes,
      :list_witness_votes,
      :list_witnesses,
      :verify_account_authority,
      :verify_authority,
      :verify_signatures,
      :find_proposals,
      :list_proposal_votes,
      :list_proposals
    ],
    follow_api: [
      :get_account_reputations,
      :get_blog,
      :get_blog_authors,
      :get_blog_entries,
      :get_feed,
      :get_feed_entries,
      :get_follow_count,
      :get_followers,
      :get_following,
      :get_reblogged_by
    ],
    jsonrpc: [
      :get_methods,
      :get_signature
    ],
    market_history_api: [
      :get_market_history,
      :get_market_history_buckets,
      :get_order_book,
      :get_recent_trades,
      :get_ticker,
      :get_trade_history,
      :get_volume
    ],
    network_broadcast_api: [
      :broadcast_block,
      :broadcast_transaction
    ],
    rc_api: [
      :find_rc_accounts,
      :get_resource_params,
      :get_resource_pool
    ],
    tags_api: [
      :get_active_votes,
      :get_comment_discussions_by_payout,
      :get_content_replies,
      :get_discussion,
      :get_discussions_by_active,
      :get_discussions_by_author_before_date,
      :get_discussions_by_blog,
      :get_discussions_by_cashout,
      :get_discussions_by_children,
      :get_discussions_by_comments,
      :get_discussions_by_created,
      :get_discussions_by_feed,
      :get_discussions_by_hot,
      :get_discussions_by_promoted,
      :get_discussions_by_trending,
      :get_discussions_by_votes,
      :get_post_discussions_by_payout,
      :get_replies_by_last_update,
      :get_tags_used_by_author,
      :get_trending_tags
    ],
    reputation_api: [
      :get_account_reputations
    ],
    bridge: [
      :account_notifications,
      :get_community,
      :get_ranked_posts,
      :list_all_subscriptions,
      :list_community_roles,
    ]
  }
  
  API_METHOD_SIGNATURES = {
    database_api: {
      find_account_recovery_requests: {accounts: []},
      find_accounts: {accounts: []},
      find_change_recovery_account_requests: {accounts: []},
      find_comments: {comments: []},
      find_decline_voting_rights_requests: {accounts: []},
      find_escrows: {from: String},
      find_limit_orders: {account: String},
      find_owner_histories: {owner: String},
      find_proposals: {proposal_ids: []},
      find_savings_withdrawals: {account: String},
      find_sbd_conversion_requests: {account: String},
      find_vesting_delegation_expirations: {account: String},
      find_vesting_delegations: {account: String},
      find_votes: {author: String, permlink: String},
      find_withdraw_vesting_routes: {account: String, order: String},
      find_witnesses: {owners: []},
      get_active_witnesses: {},
      get_config: {},
      get_current_price_feed: {},
      get_dynamic_global_properties: {},
      get_feed_history: {},
      get_hardfork_properties: {},
      get_order_book: {limit: Integer},
      get_potential_signatures: {trx: {}},
      get_required_signatures: {trx: {}, available_keys: []},
      get_reward_funds: {},
      get_transaction_hex: {trx: {}},
      get_version: {},
      get_witness_schedule: {},
      list_account_recovery_requests: {start: NilClass, limit: Integer, order: String},
      list_accounts: {start: NilClass, limit: Integer, order: String},
      list_change_recovery_account_requests: {start: NilClass, limit: Integer, order: String},
      list_comments: {start: NilClass, limit: Integer, order: String},
      list_decline_voting_rights_requests: {start: NilClass, limit: Integer, order: String},
      list_escrows: {start: NilClass, limit: Integer, order: String},
      list_limit_orders: {start: NilClass, limit: Integer, order: String},
      list_owner_histories: {start: NilClass, limit: Integer},
      list_proposal_votes: {start: NilClass, limit: Integer, order: String, order_direction: String, status: String},
      list_proposals: {start: NilClass, limit: Integer, order: String, order_direction: String, status: String},
      list_savings_withdrawals: {start: NilClass, limit: Integer, order: String},
      list_sbd_conversion_requests: {start: NilClass, limit: Integer, order: String},
      list_vesting_delegation_expirations: {start: NilClass, limit: Integer, order: String},
      list_vesting_delegations: {start: NilClass, limit: Integer, order: String},
      list_votes: {start: NilClass, limit: Integer, order: String},
      list_withdraw_vesting_routes: {start: NilClass, limit: Integer, order: String},
      list_witness_votes: {start: NilClass, limit: Integer, order: String},
      list_witnesses: {start: NilClass, limit: Integer, order: String},
      verify_account_authority: {account: String, signers: []},
      verify_authority: {trx: {}},
      verify_signatures: {hash: String, signatures: [], required_owner: [], required_active: [], required_posting: [], required_other: []}
    },
    jsonrpc: {
      get_methods: {},
      get_signature: {method: String}
    },
    reputation_api: {
      get_account_reputations: {account_lower_bound: String, limit: Integer}
    },
    bridge: {
      account_notifications: {account: String, limit: Integer},
      get_community: {name: String, observer: String},
      get_ranked_posts: {sort: String, tag: String, observer: String, limit: Integer},
      list_all_subscriptions: {account: String},
      list_community_roles: {community: String}
    }
  }
end
