import {
  FontAwesomeIcon,
  FontAwesomeLayers,
  FontAwesomeLayersText,
} from '@fortawesome/vue-fontawesome'
import Vue from 'vue'

import {config, library, dom} from '@fortawesome/fontawesome-svg-core'
import {
  faTimes as fasTimes,
  faChevronDown as fasChevronDown,
  faPuzzlePiece as fasPuzzlePiece,
  faGlobe as fasGlobe,
  faExternalLinkAlt as fasExternalLinkAlt,
  faWallet as fasWallet,
} from '@fortawesome/free-solid-svg-icons'
import {
  faHive as fabHive,
  faYoutube as fabYoutube,
  faTwitter as fabTwitter,
  faFacebook as fabFacebook,
  faQuora as fabQuora,
  faGitlab as fabGitlab,
  faGithub as fabGithub,
  faMedium as fabMedium,
  faChrome as fabChrome,
  faSafari as fabSafari,
  faFirefox as fabFirefox,
  faTelegram as fabTelegram,
  faDiscord as fabDiscord,
  faReddit as fabReddit,
  faAndroid as fabAndroid,
  faLinux as fabLinux,
  faAppStoreIos as fabAppStoreIos,
  faWindows as fabWindows,
  faApple as fabApple,
  faLinkedin as fabLinkedin,
  faInstagram as fabInstagram,
} from '@fortawesome/free-brands-svg-icons'

dom.watch()

// This is important, we are going to let Nuxt.js worry about the CSS
config.autoAddCss = false

const fabBrave: any = {
  prefix: 'fab',
  iconName: 'brave',
  icon: [
    26,
    28,
    [],
    'e002',
    'M8.585938,0 L6.6230469,1.9628906 C5.8686522,1.8591986 5.1169404,1.9627818 4.4667969,2.265625 C3.5799707,2.6787173 2.8091588,3.2898678 2.2753906,3.9902344 L0.6738281,6.0878906 L1.7832031,7.1972656 L0.9453125,8.875 L3.6523438,20.611328 C3.9508425,21.902741 4.7498933,23.023996 5.875,23.726562 L11.939453,27.517578 C12.586669,27.923087 13.413331,27.923087 14.060547,27.517578 L20.125,23.726562 C21.248998,23.023439 22.049126,21.902879 22.347656,20.611328 L25.054688,8.875 L24.216797,7.1972656 L25.326172,6.0878906 L23.724609,3.9902344 C23.190841,3.2898678 22.420029,2.6787173 21.533203,2.265625 C20.88306,1.9627818 20.131348,1.8591986 19.376953,1.9628906 L17.414062,0 L17,0 L8.585938,0 Z M13,4.2324219 C13.352939,4.2324219 13.704901,4.2890034 14.044922,4.4023438 L15.050781,4.7382812 C15.666291,4.9434511 16.331756,4.9434511 16.947266,4.7382812 L16.949219,4.7382812 L18.021484,4.3789062 C18.414823,4.2479461 18.840152,4.3693213 19.105469,4.6875 L21.779297,7.8964844 C22.324737,8.550883 22.332106,9.483138 21.800781,10.146484 L19.558594,12.949219 C19.135583,13.477982 19.009451,14.188469 19.222656,14.830078 L19.416016,15.408203 C19.67362,16.180346 19.440076,17.023756 18.824219,17.554688 L18.822266,17.556641 L17.628906,18.603516 L14.523438,16.71875 L14.511719,16.712891 C14.353397,16.622679 14.168697,16.639277 14,16.580078 L14,14.720703 L17.195312,13.65625 L16.212891,9.728516 L19.242188,8.970703 L18.757812,7.0292969 L13.787109,8.271484 L14.804688,12.34375 L13,12.945312 L11.195312,12.34375 L12.212891,8.271484 L7.242188,7.0292969 L6.7578125,8.970703 L9.787109,9.728516 L8.804688,13.65625 L12,14.720703 L12,16.599609 C11.829398,16.663089 11.641653,16.650559 11.482422,16.746094 L8.378906,18.607422 L7.662109,17.976562 L7.658203,17.972656 C6.8887614,17.309206 6.738538,16.195233 7.302734,15.349609 L7.351562,15.275391 L7.353516,15.273438 C7.899472,14.453487 7.76072,13.337574 7.027344,12.677734 L4.1933594,10.125 C3.6793597,9.459772 3.6867014,8.543474 4.2285156,7.8964844 L6.9921875,4.5996094 C7.275426,4.261746 7.730482,4.1484768 8.138672,4.3164062 L8.933594,4.6425781 C9.598059,4.9155637 10.33911,4.9413513 11.021484,4.7128906 L11.953125,4.4023438 C12.293146,4.2890035 12.647061,4.2324219 13,4.2324219 Z M4.0292969,5.0214844 L3.7519531,5.3515625 L3.8652344,5.203125 C3.9089002,5.1458304 3.9722324,5.0829519 4.0292969,5.0214844 Z M13.013672,18.318359 C13.188265,18.316256 13.363628,18.359231 13.521484,18.449219 L16.052734,19.988281 L13.660156,22.087891 C13.277261,22.424129 12.723488,22.424787 12.339844,22.087891 L9.955078,19.992188 L12.509766,18.460938 C12.665257,18.367643 12.839079,18.320463 13.013672,18.318359 Z',
  ],
}

/* const fabSteem: any = {
  prefix: 'fab',
  iconName: 'steem',
  icon: [
    590.95,
    590.95,
    [],
    'e001',
    'M295.47,0C132.29,0,0,132.29,0,295.47s132.29,295.47,295.47,295.47s295.47-132.29,295.47-295.47 S458.66,0,295.47,0z M221.64,397.6l-2.81,2.82c-5.78,5.81-11.97,11.32-18.4,16.39l-7.35,5.79c-0.49,0.39-1.08,0.59-1.67,0.59 c-0.5,0-1-0.14-1.45-0.42c-0.98-0.62-1.45-1.75-1.2-2.88l2.93-13.06c3.19-14.24,2.48-29.1-2.05-42.98l-1.57-4.82 c-1.82-5.58-3.95-11.14-6.33-16.52l-0.01-0.02l-34.16-80.51l-3.66-10.96c-1.13-3.39-1.9-6.91-2.3-10.45l-0.62-5.5 c-1.74-15.48,3.56-30.7,14.55-41.75l2.81-2.82c5.78-5.81,11.97-11.33,18.4-16.39l7.35-5.79c0.91-0.72,2.13-0.78,3.11-0.16 c0.98,0.62,1.45,1.75,1.2,2.88l-2.93,13.06c-3.19,14.24-2.49,29.1,2.05,42.98l1.57,4.82c1.82,5.58,3.95,11.14,6.33,16.52 l34.17,80.52l3.66,10.96c1.13,3.39,1.9,6.91,2.3,10.45l0.62,5.5C237.94,371.34,232.63,386.56,221.64,397.6z M336.99,424.02 l-3.6,3.62c-7.27,7.31-15.07,14.26-23.17,20.64l-9.61,7.57c-0.54,0.42-1.18,0.64-1.82,0.64c-0.54,0-1.09-0.15-1.58-0.46 c-1.07-0.67-1.59-1.91-1.31-3.15l3.79-16.91c4.03-17.99,3.14-36.77-2.59-54.29l-2-6.11c-2.31-7.06-4.99-14.08-7.99-20.86l-0.01-0.02 l-43.09-101.55l-4.61-13.81c-1.42-4.25-2.38-8.65-2.88-13.09l-0.79-7.02c-2.18-19.39,4.46-38.45,18.23-52.28l3.6-3.62 c7.28-7.31,15.07-14.26,23.17-20.64l9.6-7.57c0.99-0.78,2.33-0.86,3.4-0.18c1.07,0.67,1.59,1.91,1.31,3.15l-3.79,16.91 c-4.03,17.99-3.14,36.77,2.59,54.29l2,6.11c2.3,7.05,4.99,14.07,7.99,20.86l43.09,101.56l4.61,13.81c1.41,4.25,2.38,8.65,2.88,13.09 l0.79,7.02C357.39,391.13,350.75,410.19,336.99,424.02z M435.4,397.6l-2.81,2.82c-5.78,5.81-11.97,11.32-18.4,16.39l-7.35,5.79 c-0.49,0.39-1.08,0.59-1.67,0.59c-0.5,0-1-0.14-1.45-0.42c-0.98-0.62-1.45-1.75-1.2-2.88l2.93-13.06 c3.19-14.24,2.48-29.1-2.05-42.98l-1.57-4.82c-1.82-5.58-3.95-11.14-6.33-16.52l-0.01-0.02l-34.16-80.51l-3.66-10.96 c-1.13-3.39-1.9-6.91-2.3-10.45l-0.62-5.5c-1.74-15.48,3.56-30.7,14.55-41.75l2.81-2.82c5.78-5.81,11.97-11.33,18.4-16.39l7.35-5.79 c0.91-0.72,2.13-0.78,3.11-0.16c0.98,0.62,1.45,1.75,1.2,2.88l-2.93,13.06c-3.19,14.24-2.49,29.1,2.05,42.98l1.57,4.82 c1.82,5.58,3.95,11.14,6.33,16.52l34.17,80.52l3.66,10.96c1.13,3.39,1.9,6.91,2.3,10.45l0.62,5.5 C451.69,371.34,446.39,386.56,435.4,397.6z'
  ]
}

const fabSteemit: any = {
  prefix: 'fab',
  iconName: 'steemit',
  icon: [
    38,
    38,
    [],
    'e002',
    'M32.7004951,11.3807248 C31.1310771,9.81140963 29.3043776,8.66313021 27.3619013,7.92312792 C28.4939405,4.59311764 32.5075339,3.38104493 32.5075339,3.38104493 C32.5075339,3.38104493 23.1424826,-1.48000457 12.7997611,0.459311764 C9.35218721,1.00793415 6.0461183,3.12587173 3.62767097,5.92001831 C-1.62087426,11.9803819 -0.926213868,21.1028239 5.18422484,26.3083572 C6.1233028,27.1121528 8.22014805,28.3625014 8.2587403,28.4262947 C6.8822836,31.9221676 2.48276772,32.8790671 2.48276772,32.8790671 C2.48276772,32.8790671 8.29733255,36.5152853 16.10583,37.4594261 C18.1769471,37.7145993 20.3767051,37.7783926 22.6536475,37.5359781 C26.2684544,37.2425289 29.8703972,35.3287299 32.6104465,32.6366526 C38.5407881,26.7931863 38.5922444,17.2752258 32.7004951,11.3807248 Z M30.0247661,30.3145765 C27.8121441,32.4835487 24.5060752,33.861484 21.9589871,34.0528639 C20.1580157,34.2314851 18.2284034,34.2570024 16.3759757,34.0273465 C13.6487905,33.6956214 11.680586,32.9428604 9.75097374,32.2156168 C10.7286439,31.271476 11.7063141,29.9700926 12.1051006,28.8473305 C12.3623823,28.1838802 12.3366541,27.4438779 12.0279162,26.7931863 C9.95679906,22.5317938 10.8572848,17.4283297 14.2662664,14.1110781 C16.73617,11.6996913 20.1322875,10.5641706 23.5798614,10.9852064 C26.1140854,11.2914142 28.416756,12.4014176 30.2177274,14.2003887 C34.5915151,18.5893678 34.4371461,26.014908 30.0247661,30.3145765 Z'
  ]
} */

library.add(
  fabLinkedin,
  fabHive,
  fabYoutube,
  fabFacebook,
  fabQuora,
  fabTwitter,
  fabGitlab,
  fabGithub,
  fabMedium,
  fabChrome,
  fabSafari,
  fabFirefox,
  fabTelegram,
  fabDiscord,
  fabReddit,
  fabAndroid,
  fabLinux,
  fabAppStoreIos,
  fabWindows,
  fabApple,
  fabHive,
  fabBrave,
  fasPuzzlePiece,
  fasGlobe,
  fasExternalLinkAlt,
  fasChevronDown,
  fasTimes,
  fabInstagram,
  fasWallet,
)

Vue.component('fa-icon', FontAwesomeIcon)
Vue.component('fa-layer', FontAwesomeLayers)
Vue.component('fa-text', FontAwesomeLayersText)
// @ts-ignore
Vue.prototype.$faBrands = Object.keys(library.definitions.fab)
