from __future__ import annotations

from beekeepy.exceptions.base import (
    BeekeeperExecutableError,
    BeekeeperHandleError,
    BeekeepyError,
    DetectableError,
    InvalidatedStateError,
    SchemaDetectableError,
)
from beekeepy.exceptions.common import (
    BeekeeperFailedToStartError,
    BeekeeperIsNotRunningError,
    DetachRemoteBeekeeperError,
    InvalidatedStateByClosingBeekeeperError,
    InvalidatedStateByClosingSessionError,
    InvalidWalletNameError,
    NotPositiveTimeError,
    TimeoutReachWhileCloseError,
    TimeTooBigError,
    UnknownDecisionPathError,
    WalletIsLockedError,
)
from beekeepy.exceptions.detectable import (
    InvalidAccountNameError,
    InvalidPasswordError,
    InvalidPrivateKeyError,
    InvalidPublicKeyError,
    InvalidSchemaHexError,
    InvalidSchemaPrivateKeyError,
    InvalidSchemaPublicKeyError,
    InvalidWalletError,
    MissingSTMPrefixError,
    NotExistingKeyError,
    NoWalletWithSuchNameError,
    WalletWithSuchNameAlreadyExistsError,
)

__all__ = [
    "BeekeeperExecutableError",
    "BeekeeperFailedToStartError",
    "BeekeeperHandleError",
    "BeekeeperIsNotRunningError",
    "BeekeepyError",
    "DetachRemoteBeekeeperError",
    "DetectableError",
    "InvalidAccountNameError",
    "InvalidatedStateByClosingBeekeeperError",
    "InvalidatedStateByClosingSessionError",
    "InvalidatedStateError",
    "InvalidPasswordError",
    "InvalidPrivateKeyError",
    "InvalidPublicKeyError",
    "InvalidSchemaHexError",
    "InvalidSchemaPrivateKeyError",
    "InvalidSchemaPublicKeyError",
    "InvalidWalletError",
    "InvalidWalletNameError",
    "MissingSTMPrefixError",
    "NotExistingKeyError",
    "NotPositiveTimeError",
    "NoWalletWithSuchNameError",
    "SchemaDetectableError",
    "TimeoutReachWhileCloseError",
    "TimeTooBigError",
    "UnknownDecisionPathError",
    "WalletIsLockedError",
    "WalletWithSuchNameAlreadyExistsError",
]
