from __future__ import annotations

from typing import TYPE_CHECKING

from beekeepy._utilities.smart_lazy_import import aggregate_same_import, lazy_module_factory

__all__ = [
    "ApiNotFoundError",
    "BatchRequestError",
    "BeekeeperExecutableError",
    "BeekeeperFailedToStartDuringProcessSpawnError",
    "BeekeeperFailedToStartError",
    "BeekeeperFailedToStartNotReadyOnTimeError",
    "BeekeeperHandleError",
    "BeekeeperInterfaceError",
    "BeekeeperIsNotRunningError",
    "BeekeepyError",
    "CommunicationError",
    "CommunicationResponseT",
    "DetachRemoteBeekeeperError",
    "DetectableError",
    "DifferenceBetweenAmountOfRequestsAndResponsesError",
    "ErrorInResponseError",
    "ExecutableError",
    "ExecutableIsNotRunningError",
    "FailedToDetectReservedPortsError",
    "FailedToDetectRunningBeekeeperError",
    "FailedToStartExecutableError",
    "GroupedErrorsError",
    "InvalidAccountNameError",
    "InvalidatedStateByClosingBeekeeperError",
    "InvalidatedStateByClosingSessionError",
    "InvalidatedStateError",
    "InvalidOptionError",
    "InvalidPasswordError",
    "InvalidPrivateKeyError",
    "InvalidPublicKeyError",
    "InvalidSchemaHexError",
    "InvalidSchemaPrivateKeyError",
    "InvalidSchemaPublicKeyError",
    "InvalidWalletError",
    "Json",
    "JussiResponseError",
    "MissingSTMPrefixError",
    "NotExistingKeyError",
    "NothingToSendError",
    "NotPositiveTimeError",
    "NoWalletWithSuchNameError",
    "NullResultError",
    "OverseerError",
    "OverseerInvalidPasswordError",
    "ProcessSearchError",
    "ResponseNotReadyError",
    "SchemaDetectableError",
    "TimeoutExceededError",
    "TimeoutReachWhileCloseError",
    "TimeTooBigError",
    "UnableToAcquireDatabaseLockError",
    "UnableToAcquireForkdbLockError",
    "UnableToOpenWalletError",
    "UndistinguishableBeekeeperInstancesError",
    "UnknownDecisionPathError",
    "UnknownValueForBooleanConversionError",
    "UnlockIsNotAccessibleError",
    "UnparsableResponseError",
    "UnsupportedCommunicatorTypeError",
    "WalletIsAlreadyUnlockedError",
    "WalletIsLockedError",
    "WalletWithSuchNameAlreadyExistsError",
]

if TYPE_CHECKING:
    from beekeepy._exceptions.base import (
        BeekeeperExecutableError,
        BeekeeperFailedToStartError,
        BeekeeperHandleError,
        BeekeeperInterfaceError,
        BeekeepyError,
        CommunicationError,
        CommunicationResponseT,
        DetectableError,
        ExecutableError,
        InvalidatedStateError,
        Json,
        OverseerError,
        ProcessSearchError,
        SchemaDetectableError,
    )
    from beekeepy._exceptions.common import (
        BatchRequestError,
        BeekeeperFailedToStartDuringProcessSpawnError,
        BeekeeperFailedToStartNotReadyOnTimeError,
        BeekeeperIsNotRunningError,
        DetachRemoteBeekeeperError,
        InvalidatedStateByClosingBeekeeperError,
        InvalidatedStateByClosingSessionError,
        InvalidOptionError,
        NothingToSendError,
        NotPositiveTimeError,
        ResponseNotReadyError,
        TimeoutExceededError,
        TimeTooBigError,
        UnknownDecisionPathError,
        UnknownValueForBooleanConversionError,
        UnsupportedCommunicatorTypeError,
        WalletIsLockedError,
    )
    from beekeepy._exceptions.detectable import (
        InvalidAccountNameError,
        InvalidPasswordError,
        InvalidPrivateKeyError,
        InvalidPublicKeyError,
        InvalidSchemaHexError,
        InvalidSchemaPrivateKeyError,
        InvalidSchemaPublicKeyError,
        InvalidWalletError,
        MissingSTMPrefixError,
        NotExistingKeyError,
        NoWalletWithSuchNameError,
        WalletWithSuchNameAlreadyExistsError,
    )
    from beekeepy._exceptions.executable import (
        ExecutableIsNotRunningError,
        FailedToDetectReservedPortsError,
        FailedToDetectRunningBeekeeperError,
        FailedToStartExecutableError,
        TimeoutReachWhileCloseError,
        UndistinguishableBeekeeperInstancesError,
    )
    from beekeepy._exceptions.overseer import (
        ApiNotFoundError,
        DifferenceBetweenAmountOfRequestsAndResponsesError,
        ErrorInResponseError,
        GroupedErrorsError,
        JussiResponseError,
        NullResultError,
        OverseerInvalidPasswordError,
        UnableToAcquireDatabaseLockError,
        UnableToAcquireForkdbLockError,
        UnableToOpenWalletError,
        UnlockIsNotAccessibleError,
        UnparsableResponseError,
        WalletIsAlreadyUnlockedError,
    )

__getattr__ = lazy_module_factory(
    globals(),
    # Translations
    *aggregate_same_import(
        "BeekeeperExecutableError",
        "BeekeeperFailedToStartError",
        "BeekeeperHandleError",
        "BeekeeperInterfaceError",
        "BeekeepyError",
        "CommunicationError",
        "CommunicationResponseT",
        "DetectableError",
        "ExecutableError",
        "InvalidatedStateError",
        "Json",
        "OverseerError",
        "ProcessSearchError",
        "SchemaDetectableError",
        module="beekeepy._exceptions.base",
    ),
    *aggregate_same_import(
        "BatchRequestError",
        "BeekeeperFailedToStartDuringProcessSpawnError",
        "BeekeeperFailedToStartNotReadyOnTimeError",
        "BeekeeperIsNotRunningError",
        "DetachRemoteBeekeeperError",
        "InvalidatedStateByClosingBeekeeperError",
        "InvalidatedStateByClosingSessionError",
        "InvalidOptionError",
        "NothingToSendError",
        "NotPositiveTimeError",
        "ResponseNotReadyError",
        "TimeoutExceededError",
        "TimeTooBigError",
        "UnknownDecisionPathError",
        "UnknownValueForBooleanConversionError",
        "UnsupportedCommunicatorTypeError",
        "WalletIsLockedError",
        module="beekeepy._exceptions.common",
    ),
    *aggregate_same_import(
        "InvalidAccountNameError",
        "InvalidPasswordError",
        "InvalidPrivateKeyError",
        "InvalidPublicKeyError",
        "InvalidSchemaHexError",
        "InvalidSchemaPrivateKeyError",
        "InvalidSchemaPublicKeyError",
        "InvalidWalletError",
        "MissingSTMPrefixError",
        "NotExistingKeyError",
        "NoWalletWithSuchNameError",
        "WalletWithSuchNameAlreadyExistsError",
        module="beekeepy._exceptions.detectable",
    ),
    *aggregate_same_import(
        "ExecutableIsNotRunningError",
        "FailedToDetectReservedPortsError",
        "FailedToDetectRunningBeekeeperError",
        "FailedToStartExecutableError",
        "TimeoutReachWhileCloseError",
        "UndistinguishableBeekeeperInstancesError",
        module="beekeepy._exceptions.executable",
    ),
    *aggregate_same_import(
        "ApiNotFoundError",
        "DifferenceBetweenAmountOfRequestsAndResponsesError",
        "ErrorInResponseError",
        "GroupedErrorsError",
        "JussiResponseError",
        "NullResultError",
        "OverseerInvalidPasswordError",
        "UnableToAcquireDatabaseLockError",
        "UnableToAcquireForkdbLockError",
        "UnableToOpenWalletError",
        "UnlockIsNotAccessibleError",
        "UnparsableResponseError",
        "WalletIsAlreadyUnlockedError",
        module="beekeepy._exceptions.overseer",
    ),
)
