# HELpy

Hive Execution Layer in Python. Easily interact with the Hive blockchain using Python.

---

## Table of contents

1. [Introduction](#introduction)
2. [Features](#features)
2. [Example Usage](#example-usage)
3. [Communication Libraries](#communication-libraries)
4. [Connection Configuration](#connection-configuration)
4. [Logging Configuration](#logging-configuration)

## Introduction

HELpy is an open-source Python library designed to simplify interactions with the Hive blockchain. With HELpy, you can seamlessly connect to the Hive network, query data, and perform various blockchain operations with ease. Whether you're building decentralized applications, exploring blockchain data, or automating tasks on Hive, HELpy provides a powerful and user-friendly toolkit to streamline your development process.

## Features

- **Comprehensive API Definitions**: HELpy includes definitions for all the APIs available in both **hived** and **beekeeper**, making it a complete solution for interacting with the Hive blockchain.
- **Synchronous and Asynchronous Support**: Helpy offers both synchronous and asynchronous versions of its API.
- **Predefined Communication Clients**: HELpy comes with predefined communicators using popular Python libraries such as `requests`, `aiohttp`, and `httpx`, allowing you to choose the most suitable HTTP client for your use case.
- **Out-of-the-Box Usability**: HELpy is designed to work without requiring any external binaries or additional software. It's ready to use immediately after installation, making it a true out-of-the-box solution for Hive blockchain interactions.

## Example Usage

```python
from helpy import Hived, Settings, HttpUrl

hived = Hived(settings=Settings(http_endpoint=HttpUrl("http://localhost:8080")))
gdpo = hived.api.database.get_dynamic_properties()
print(f"Current block num is: {gdpo.head_block_number}")
```

## Communication Libraries

HELpy supports multiple communication libraries, giving you flexibility in choosing how you interact with the Hive blockchain:
- **requests**: A widely-used synchronous HTTP library.
- **aiohttp**: An asynchronous HTTP library perfect for non-blocking I/O operations.
- **httpx**: Another powerful HTTP client supporting both synchronous and asynchronous requests.

Each of these libraries is seamlessly integrated, so you can switch between them based on your application’s needs.

## Connection Configuration

Configuring a connection to the Hive blockchain is simple and flexible, thanks to the provided `Settings` class. You can quickly set up your connection parameters and begin interacting with the Hive network with minimal effort. All of `Settings` members are documented.


## Logging Configuration

To reduce amount of logs generated by helpy You can disable them by simply:

```python
from loguru import logger

logger.disable("helpy")
```
