from __future__ import annotations

import time
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from local_tools.beekeepy.models import WalletInfo

    from beekeepy.handle.runnable import Beekeeper


def test_api_set_timeout(beekeeper: Beekeeper, wallet: WalletInfo) -> None:  # noqa: ARG001
    """Test test_api_set_timeout will test beekeeper_api.set_timeout api call."""
    # ARRANGE
    bk_wallet = (beekeeper.api.list_created_wallets()).wallets[0]
    assert bk_wallet.unlocked is True, "Wallet should be unlocked."

    # ACT
    beekeeper.api.set_timeout(seconds=1)
    time.sleep(1.5)

    # ASSERT
    bk_wallet = (beekeeper.api.list_created_wallets()).wallets[0]
    assert bk_wallet.unlocked is False, "Wallet after timeout should be locked."
