from __future__ import annotations

from beekeepy.exceptions.base import (
    BeekeeperExecutableError,
    BeekeeperFailedToStartError,
    BeekeeperHandleError,
    BeekeeperInterfaceError,
    BeekeepyError,
    CommunicationError,
    DetectableError,
    ExecutableError,
    InvalidatedStateError,
    Json,
    OverseerError,
    SchemaDetectableError,
)
from beekeepy.exceptions.common import (
    BatchRequestError,
    BeekeeperFailedToStartDuringProcessSpawnError,
    BeekeeperFailedToStartNotReadyOnTimeError,
    BeekeeperIsNotRunningError,
    DetachRemoteBeekeeperError,
    InvalidatedStateByClosingBeekeeperError,
    InvalidatedStateByClosingSessionError,
    InvalidOptionError,
    NothingToSendError,
    NotPositiveTimeError,
    ResponseNotReadyError,
    TimeoutExceededError,
    TimeoutReachWhileCloseError,
    TimeTooBigError,
    UnknownDecisionPathError,
    WalletIsLockedError,
)
from beekeepy.exceptions.detectable import (
    InvalidAccountNameError,
    InvalidPasswordError,
    InvalidPrivateKeyError,
    InvalidPublicKeyError,
    InvalidSchemaHexError,
    InvalidSchemaPrivateKeyError,
    InvalidSchemaPublicKeyError,
    InvalidWalletError,
    MissingSTMPrefixError,
    NotExistingKeyError,
    NoWalletWithSuchNameError,
    WalletWithSuchNameAlreadyExistsError,
)
from beekeepy.exceptions.executable import (
    ExecutableIsNotRunningError,
    FailedToDetectReservedPortsError,
    FailedToStartExecutableError,
)
from beekeepy.exceptions.executable import (
    TimeoutReachWhileCloseError as ExecutableTimeoutReachWhileCloseError,
)
from beekeepy.exceptions.overseer import (
    ApiNotFoundError,
    DifferenceBetweenAmountOfRequestsAndResponsesError,
    ErrorInResponseError,
    GroupedErrorsError,
    JussiResponseError,
    NullResultError,
    OverseerInvalidPasswordError,
    UnableToAcquireDatabaseLockError,
    UnableToAcquireForkdbLockError,
    UnableToOpenWalletError,
    UnlockIsNotAccessibleError,
    UnparsableResponseError,
    WalletIsAlreadyUnlockedError,
)

__all__ = [
    "ApiNotFoundError",
    "BatchRequestError",
    "BeekeeperExecutableError",
    "BeekeeperFailedToStartDuringProcessSpawnError",
    "BeekeeperFailedToStartError",
    "BeekeeperFailedToStartNotReadyOnTimeError",
    "BeekeeperHandleError",
    "BeekeeperInterfaceError",
    "BeekeeperIsNotRunningError",
    "BeekeepyError",
    "CommunicationError",
    "DetachRemoteBeekeeperError",
    "DetectableError",
    "DifferenceBetweenAmountOfRequestsAndResponsesError",
    "ErrorInResponseError",
    "ExecutableError",
    "ExecutableIsNotRunningError",
    "ExecutableTimeoutReachWhileCloseError",
    "FailedToDetectReservedPortsError",
    "FailedToStartExecutableError",
    "GroupedErrorsError",
    "InvalidAccountNameError",
    "InvalidatedStateByClosingBeekeeperError",
    "InvalidatedStateByClosingSessionError",
    "InvalidatedStateError",
    "InvalidOptionError",
    "InvalidPasswordError",
    "InvalidPrivateKeyError",
    "InvalidPublicKeyError",
    "InvalidSchemaHexError",
    "InvalidSchemaPrivateKeyError",
    "InvalidSchemaPublicKeyError",
    "InvalidWalletError",
    "Json",
    "JussiResponseError",
    "MissingSTMPrefixError",
    "NotExistingKeyError",
    "NothingToSendError",
    "NotPositiveTimeError",
    "NoWalletWithSuchNameError",
    "NullResultError",
    "OverseerError",
    "OverseerInvalidPasswordError",
    "ResponseNotReadyError",
    "SchemaDetectableError",
    "TimeoutExceededError",
    "TimeoutReachWhileCloseError",
    "TimeTooBigError",
    "UnableToAcquireDatabaseLockError",
    "UnableToAcquireForkdbLockError",
    "UnableToOpenWalletError",
    "UnknownDecisionPathError",
    "UnlockIsNotAccessibleError",
    "UnparsableResponseError",
    "WalletIsAlreadyUnlockedError",
    "WalletIsLockedError",
    "WalletWithSuchNameAlreadyExistsError",
]
