from __future__ import annotations

from beekeepy.exceptions.base import (
    BeekeeperExecutableError,
    BeekeeperFailedToStartError,
    BeekeeperHandleError,
    BeekeepyError,
    DetectableError,
    InvalidatedStateError,
    SchemaDetectableError,
)
from beekeepy.exceptions.common import (
    BeekeeperFailedToStartDuringProcessSpawnError,
    BeekeeperFailedToStartNotReadyOnTimeError,
    BeekeeperIsNotRunningError,
    DetachRemoteBeekeeperError,
    InvalidatedStateByClosingBeekeeperError,
    InvalidatedStateByClosingSessionError,
    NotPositiveTimeError,
    TimeoutReachWhileCloseError,
    TimeTooBigError,
    WalletIsLockedError,
)
from beekeepy.exceptions.detectable import (
    InvalidAccountNameError,
    InvalidPasswordError,
    InvalidPrivateKeyError,
    InvalidPublicKeyError,
    InvalidSchemaHexError,
    InvalidSchemaPrivateKeyError,
    InvalidSchemaPublicKeyError,
    InvalidWalletError,
    MissingSTMPrefixError,
    NotExistingKeyError,
    NoWalletWithSuchNameError,
    WalletWithSuchNameAlreadyExistsError,
)
from helpy.exceptions import UnknownDecisionPathError

__all__ = [
    "BeekeeperExecutableError",
    "BeekeeperFailedToStartError",
    "BeekeeperFailedToStartDuringProcessSpawnError",
    "BeekeeperFailedToStartNotReadyOnTimeError",
    "BeekeeperHandleError",
    "BeekeeperIsNotRunningError",
    "BeekeepyError",
    "DetachRemoteBeekeeperError",
    "DetectableError",
    "InvalidAccountNameError",
    "InvalidatedStateByClosingBeekeeperError",
    "InvalidatedStateByClosingSessionError",
    "InvalidatedStateError",
    "InvalidPasswordError",
    "InvalidPrivateKeyError",
    "InvalidPublicKeyError",
    "InvalidSchemaHexError",
    "InvalidSchemaPrivateKeyError",
    "InvalidSchemaPublicKeyError",
    "InvalidWalletError",
    "MissingSTMPrefixError",
    "NotExistingKeyError",
    "NotPositiveTimeError",
    "NoWalletWithSuchNameError",
    "SchemaDetectableError",
    "TimeoutReachWhileCloseError",
    "TimeTooBigError",
    "UnknownDecisionPathError",
    "WalletIsLockedError",
    "WalletWithSuchNameAlreadyExistsError",
]
