CREATE OR REPLACE FUNCTION hive.get_context_id( _context hive.context_name )
    RETURNS hive.contexts.id%TYPE
    LANGUAGE plpgsql
    STABLE
AS
$BODY$
DECLARE
    __context_id hive.contexts.id%TYPE;
BEGIN
    SELECT hac.id INTO __context_id
    FROM hive.contexts hac
    WHERE hac.name = _context;

    IF __context_id IS NULL THEN
        RAISE EXCEPTION 'No context with name %', _context;
    END IF;

    RETURN __context_id;
END;
$BODY$
;


CREATE OR REPLACE FUNCTION hive.calculate_operation_stable_id(
        _block_num hive.operations.block_num %TYPE,
        _trx_in_block hive.operations.trx_in_block %TYPE,
        _op_pos hive.operations.op_pos %TYPE
    ) RETURNS BIGINT LANGUAGE 'sql' IMMUTABLE AS $BODY$
SELECT (
        (_block_num::BIGINT << 36) |(
            CASE
                _trx_in_block = -1
                WHEN TRUE THEN 32768::BIGINT << 20
                ELSE _trx_in_block::BIGINT << 20
            END
        ) | (
            _op_pos::bigint & '000011111111111111111111'::"bit"::BIGINT
        )
    )
END;
$BODY$;
;

CREATE OR REPLACE FUNCTION hive.get_postgres_url()
    RETURNS TEXT
    LANGUAGE plpgsql
    VOLATILE
AS
$BODY$
DECLARE
    __current_pid INT;
    __database_name TEXT;
    __postgres_url TEXT;
BEGIN
    __current_pid := pg_backend_pid();
    SELECT datname AS database_name
    FROM pg_stat_activity
    WHERE pid = __current_pid INTO __database_name;

    __postgres_url := 'postgres:///' || __database_name;
    RETURN __postgres_url;
END;
$BODY$
;

-- This function is used by the consensus state provider to save its state here.
CREATE OR REPLACE FUNCTION hive.get_tablespace_location() RETURNS TEXT AS $BODY$
DECLARE
    tablespace_name TEXT;
    tablespace_location TEXT;
BEGIN
    -- Fetch the tablespace name for the current database ('haf_block_log')
    SELECT pg_tablespace.spcname 
    INTO tablespace_name
    FROM 
        pg_database 
    JOIN 
        pg_tablespace ON pg_database.dattablespace = pg_tablespace.oid 
    WHERE 
        datname = current_database();

    -- Get the location of that tablespace
    SELECT pg_tablespace_location(oid) 
    INTO tablespace_location
    FROM pg_tablespace 
    WHERE spcname = tablespace_name;

    RETURN tablespace_location;
END;
$BODY$ LANGUAGE plpgsql;
