﻿
CREATE OR REPLACE PROCEDURE haf_admin_test_given()
        LANGUAGE 'plpgsql'
AS
$BODY$
BEGIN
    CREATE SCHEMA A;
    PERFORM hive.context_create( 'context', 'a' );
    CREATE TABLE table1( id INTEGER NOT NULL, smth TEXT NOT NULL ) INHERITS( a.context );
END;
$BODY$
;

CREATE OR REPLACE PROCEDURE haf_admin_test_when()
LANGUAGE 'plpgsql'
AS
$BODY$
BEGIN
    PERFORM hive.context_next_block( 'context' );
    INSERT INTO table1( id, smth ) VALUES( 123, 'blabla1' );
    INSERT INTO table1( id, smth ) VALUES( 223, 'blabla2' );
    INSERT INTO table1( id, smth ) VALUES( 323, 'blabla3' );
    PERFORM hive.context_next_block( 'context' );
    UPDATE table1 SET id=423 WHERE id=123;
    UPDATE table1 SET id=523 WHERE id=223;
    UPDATE table1 SET id=623 WHERE id=323;
    PERFORM hive.context_next_block( 'context' );
    DELETE FROM table1 WHERE id=423;
    DELETE FROM table1 WHERE id=523;
    DELETE FROM table1 WHERE id=623;
END
$BODY$
;

CREATE OR REPLACE PROCEDURE haf_admin_test_then()
        LANGUAGE 'plpgsql'
AS
$BODY$
BEGIN
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 123 AND hs.hive_rowid = 1 AND hs.hive_block_num = 1 AND hs.hive_operation_type='INSERT' ), 'Lack of insert operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 223 AND hs.hive_rowid = 2 AND hs.hive_block_num = 1 AND hs.hive_operation_type='INSERT' ), 'Lack of insert operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 323 AND hs.hive_rowid = 3 AND hs.hive_block_num = 1 AND hs.hive_operation_type='INSERT' ), 'Lack of insert operation';

    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 123 AND hs.hive_rowid = 1 AND hs.hive_block_num = 2 AND hs.hive_operation_type='UPDATE' ), 'Lack of update operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 223 AND hs.hive_rowid = 2 AND hs.hive_block_num = 2 AND hs.hive_operation_type='UPDATE' ), 'Lack of update operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 323 AND hs.hive_rowid = 3 AND hs.hive_block_num = 2 AND hs.hive_operation_type='UPDATE' ), 'Lack of update operation';

    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 423 AND hs.hive_rowid = 1 AND hs.hive_block_num = 3 AND hs.hive_operation_type='DELETE' ), 'Lack of delete operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 523 AND hs.hive_rowid = 2 AND hs.hive_block_num = 3 AND hs.hive_operation_type='DELETE' ), 'Lack of delete operation';
    ASSERT EXISTS ( SELECT FROM hafd.shadow_public_table1 hs WHERE hs.id = 623 AND hs.hive_rowid = 3 AND hs.hive_block_num = 3 AND hs.hive_operation_type='DELETE' ), 'Lack of delete operation';

    ASSERT ( SELECT COUNT(*) FROM hafd.shadow_public_table1 ) = 9;
END
$BODY$
;




