
CREATE OR REPLACE PROCEDURE haf_admin_test_given()
        LANGUAGE 'plpgsql'
AS
$BODY$
BEGIN
    CREATE SCHEMA A;
    PERFORM hive.app_create_context( 'context_attached', 'a' );
    PERFORM hive.app_create_context( 'context_detached', 'a' );
END;
$BODY$
;

CREATE OR REPLACE PROCEDURE haf_admin_test_when()
LANGUAGE 'plpgsql'
    AS
$BODY$
BEGIN
    PERFORM hive.app_context_detach( 'context_detached' );
END;
$BODY$
;

CREATE OR REPLACE PROCEDURE haf_admin_test_then()
        LANGUAGE 'plpgsql'
AS
$BODY$
BEGIN
    ASSERT ( SELECT hive.app_context_is_attached( 'context_attached' ) ) = TRUE , 'Context is not attached';
    ASSERT ( SELECT hive.app_context_is_attached( 'context_detached' ) ) = FALSE , 'Context is attached';
END;
$BODY$
;


