---
title: 'PY: Getting Started'
position: 0
description: "The official Steem library for Python is `steem-python`. It comes with a BIP38 encrypted wallet and a practical CLI utility called `steempy`."
layout: full
---              
<span class="fa-pull-left top-of-tutorial-repo-link"><span class="first-word">Full</span>, runnable src of [Getting Started](https://github.com/steemit/devportal-tutorials-py/tree/master/tutorials/00_getting_started) can be downloaded as part of the [PY tutorials repository](https://github.com/steemit/devportal-tutorials-py).</span>
<br>



The library was designed to allow Python developers to easily access the network as well as build utilities and applications.

Currently steem-python documentation is generated in the standard [pydoc format](https://steem.readthedocs.io/en/latest/).

Documentation is available at: [Official steem-python Docs](https://github.com/steemit/steem-python).

---

#### Dev requirements

In our Python tutorials we recommend developers to be familiar with following requirements/libraries.


* Python developer should be familiar with Python 3.x and above

* Medium knowledge of package manager `pip/pip3` and/or `pipenv` is required, since our tutorials will be using package manager to get started quickly.

* Terminal (Linux/Mac) or Cmd (Windows command prompt) knowledge is also required, since most python tutorials will only work with terminal and print out result in different formats. 

* Python environment path should be set up properly so that terminal can access proper python library without conflicts.

* Additional and optional packages that we might use: setuptools, brew


To get started with Python, you can also check official [Python installation](https://wiki.python.org/moin/BeginnersGuide/Download) and [Python tutorial](https://docs.python.org/3/tutorial/).

To get started with our Python tutorials, checkout our [first tutorial here](get_posts).


---
