---
title: titles.getting_started
position: 0
description: descriptions.getting_started
layout: full
canonical_url: getting_started.html
---
Full, runnable src of [all python tutorials](https://gitlab.syncad.com/hive/devportal/-/tree/master/tutorials/python) (or download just the Python tutorials: [devportal-master-tutorials-python.zip](https://gitlab.syncad.com/hive/devportal/-/archive/master/devportal-master-tutorials-python.zip?path=tutorials/python)).

The library was designed to allow Python developers to easily access the network as well as build utilities and applications.

Currently, beem documentation is generated in the standard [pydoc format](https://beem.readthedocs.io/en/latest/).

Repository: [https://github.com/holgern/beem](https://github.com/holgern/beem).

**<a href="{{ '/quickstart/#quickstart-choose-library' | relative_url }}">Alternative Python libraries</a>**


---

#### Dev requirements

In our Python tutorials we recommend developers to be familiar with following requirements/libraries.

* Python developer should be familiar with Python 3.x and above

* Medium knowledge of package manager `pip/pip3` and/or `pipenv` is required, since our tutorials will be using package manager to get started quickly.

* Terminal (Linux/Mac) or Cmd (Windows command prompt) knowledge is also required, since most python tutorials will only work with terminal and print out result in different formats. 

* Python environment path should be set up properly so that terminal can access proper python library without conflicts.

* Additional and optional packages that we might use: setuptools, brew


To get started with Python, you can also check official [Python installation](https://wiki.python.org/moin/BeginnersGuide/Download) and [Python tutorial](https://docs.python.org/3/tutorial/).

To get started with our Python tutorials, checkout our [first tutorial here](get_posts.html).
